/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.commands;

import com.google.cloud.sql.tool.AbstractCommand;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.CommandException;
import com.google.cloud.sql.tool.Context;
import com.google.cloud.sql.tool.Sql;
import com.google.cloud.sql.tool.SqlConsole;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class SourceCommand
extends AbstractCommand {
    private final Sql.SqlChildCreator sqlChildCreator;

    public SourceCommand(Sql.SqlChildCreator sqlChildCreator) {
        super("source", '@', "Executes the argument as a sql script.");
        this.sqlChildCreator = sqlChildCreator;
    }

    @Override
    public Command.Result execute(List<String> args, Context context) throws CommandException {
        if (args.isEmpty()) {
            throw new CommandException(this, "Usage: " + this.getHelpText());
        }
        try {
            File file = new File(args.get(0));
            if (!file.isFile()) {
                throw new CommandException(this, file.getPath() + " does not exist.");
            }
            if (!file.canRead()) {
                throw new CommandException(this, "Unable to read file: " + file.getPath());
            }
            Sql child = this.sqlChildCreator.create(SqlConsole.create(new FileReader(file)));
            if (child.run() != 0) {
                throw new CommandException(this, "Unknown error executing file: " + file.getPath());
            }
        }
        catch (IOException e) {
            throw new CommandException(this, e.getMessage(), e);
        }
        return Command.Result.OK;
    }
}

