/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import sun.misc.Unsafe;

public final class ReflectionUtils {
    private static final String USER_CLASSLOADER_PROD = "com.google.apphosting.runtime.security.UserClassLoader";
    private static final String USER_CLASS_LOADER_DEV = "com.google.appengine.tools.development.IsolatedAppClassLoader";
    private static Unsafe theUnsafe;
    private static final Set<String> allocateInstanceExceptionSet;

    private ReflectionUtils() {
    }

    public static Object allocateInstance(Class<?> klass) throws InstantiationException {
        if (null == klass) {
            throw new NullPointerException();
        }
        ReflectionUtils.checkFullClassHierarchyIsSafeToAllocateInstance(klass, ReflectionUtils.getUserClassLoader());
        return theUnsafe.allocateInstance(klass);
    }

    private static ClassLoader getUserClassLoader() {
        ClassLoader userClassLoader = ReflectionUtils.getUserClassLoader(USER_CLASSLOADER_PROD);
        if (null == userClassLoader) {
            userClassLoader = ReflectionUtils.getUserClassLoader(USER_CLASS_LOADER_DEV);
        }
        return userClassLoader;
    }

    private static ClassLoader getUserClassLoader(final String classLoaderClassName) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                while (current != null) {
                    if (current.getClass().getName().equals(classLoaderClassName)) {
                        return current;
                    }
                    current = current.getClass().getClassLoader();
                }
                return current;
            }
        });
    }

    private static void checkFullClassHierarchyIsSafeToAllocateInstance(Class<?> klass, ClassLoader userClassLoader) {
        if (null == userClassLoader) {
            return;
        }
        if (!ReflectionUtils.wasLoadedByUserClassLoader(klass, userClassLoader) && !ReflectionUtils.isExceptionToAllocateInstanceRule(klass)) {
            throw new SecurityException("App Engine only supports the use of the method ReflectionUtils.allocateInstance(Class klass) on selected classes. The following may not be in the type hierarchy of the supplied class: " + klass.getName());
        }
        if (null != (klass = klass.getSuperclass())) {
            ReflectionUtils.checkFullClassHierarchyIsSafeToAllocateInstance(klass, userClassLoader);
        }
    }

    private static boolean isExceptionToAllocateInstanceRule(Class<?> klass) {
        return allocateInstanceExceptionSet.contains(klass.getName());
    }

    private static boolean wasLoadedByUserClassLoader(final Class<?> klass, final ClassLoader userClassLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                ClassLoader currentLoader = klass.getClassLoader();
                while (currentLoader != null) {
                    if (currentLoader == userClassLoader) {
                        return true;
                    }
                    currentLoader = currentLoader.getClass().getClassLoader();
                }
                return false;
            }
        });
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws NoSuchFieldException, IllegalAccessException {
                    Class<Unsafe> klass = Unsafe.class;
                    Field field = klass.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    theUnsafe = (Unsafe)field.get(null);
                    return null;
                }
            });
            allocateInstanceExceptionSet = new HashSet<String>(2);
            allocateInstanceExceptionSet.add(Object.class.getName());
            allocateInstanceExceptionSet.add(Number.class.getName());
        }
        catch (Throwable t) {
            throw new RuntimeException("Error initializing com.google.apphosting.api.ReflectionUtils", t);
        }
    }
}

