/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.YamlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebXml {
    private final List<String> servletPatterns = new ArrayList<String>();
    private final List<SecurityConstraint> securityConstraints = new ArrayList<SecurityConstraint>();
    private final List<String> welcomeFiles = new ArrayList<String>();
    private final Map<String, String> mimeMappings = new HashMap<String, String>();
    private final Map<String, String> patternToId = new HashMap<String, String>();
    private boolean fallThroughToRuntime;

    public boolean matches(String url) {
        for (String pattern : this.servletPatterns) {
            if (pattern.length() == 0) continue;
            if (pattern.startsWith("*") && url.endsWith(pattern.substring(1))) {
                return true;
            }
            if (pattern.endsWith("*") && url.startsWith(pattern.substring(0, pattern.length() - 1))) {
                return true;
            }
            if (!url.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public String getHandlerIdForPattern(String pattern) {
        return this.patternToId.get(pattern);
    }

    public void addServletPattern(String urlPattern, String id) {
        YamlUtils.validateUrl(urlPattern);
        this.servletPatterns.add(urlPattern);
        if (id != null) {
            this.patternToId.put(urlPattern, id);
        }
    }

    public List<String> getServletPatterns() {
        return this.servletPatterns;
    }

    public List<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public SecurityConstraint addSecurityConstraint() {
        SecurityConstraint context = new SecurityConstraint();
        this.securityConstraints.add(context);
        return context;
    }

    public void addWelcomeFile(String welcomeFile) {
        this.welcomeFiles.add(welcomeFile);
    }

    public List<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void addMimeMapping(String extension, String mimeType) {
        this.mimeMappings.put(extension, mimeType);
    }

    public Map<String, String> getMimeMappings() {
        return this.mimeMappings;
    }

    public String getMimeTypeForPath(String path) {
        int dot = path.lastIndexOf(".");
        if (dot != -1) {
            return this.mimeMappings.get(path.substring(dot + 1));
        }
        return null;
    }

    public boolean getFallThroughToRuntime() {
        return this.fallThroughToRuntime;
    }

    public void setFallThroughToRuntime(boolean fallThroughToRuntime) {
        this.fallThroughToRuntime = fallThroughToRuntime;
    }

    public void validate() {
        for (String welcomeFile : this.welcomeFiles) {
            if (!welcomeFile.startsWith("/")) continue;
            throw new AppEngineConfigException("Welcome files must be relative paths: " + welcomeFile);
        }
    }

    public static class SecurityConstraint {
        private final List<String> patterns;
        private TransportGuarantee transportGuarantee = TransportGuarantee.NONE;
        private RequiredRole requiredRole = RequiredRole.NONE;

        private SecurityConstraint() {
            this.patterns = new ArrayList<String>();
        }

        public List<String> getUrlPatterns() {
            return this.patterns;
        }

        public void addUrlPattern(String pattern) {
            this.patterns.add(pattern);
        }

        public TransportGuarantee getTransportGuarantee() {
            return this.transportGuarantee;
        }

        public void setTransportGuarantee(TransportGuarantee transportGuarantee) {
            this.transportGuarantee = transportGuarantee;
        }

        public RequiredRole getRequiredRole() {
            return this.requiredRole;
        }

        public void setRequiredRole(RequiredRole requiredRole) {
            this.requiredRole = requiredRole;
        }

        public static enum TransportGuarantee {
            NONE,
            INTEGRAL,
            CONFIDENTIAL;

        }

        public static enum RequiredRole {
            NONE,
            ANY_USER,
            ADMIN;

        }
    }
}

