/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.KeyRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class EmulatedXAResource
implements XAResource {
    private State state = State.NEW;
    private final KeyRegistry keyRegistry = new KeyRegistry();
    protected final DatastoreService datastoreService;

    public EmulatedXAResource(DatastoreService ds) {
        this.datastoreService = ds;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.state != State.NEW) {
            throw new XAException("Nested transactions are not supported");
        }
        this.state = State.ACTIVE;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.state != State.ACTIVE) {
            throw new XAException("A transaction has not been started, cannot commit");
        }
        this.keyRegistry.clearParentKeys();
        this.keyRegistry.clearUnownedObjects();
        this.state = State.INACTIVE;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.state != State.ACTIVE) {
            throw new XAException("A transaction has not been started, cannot rollback");
        }
        this.keyRegistry.clearParentKeys();
        this.keyRegistry.clearUnownedObjects();
        this.state = State.INACTIVE;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        throw new XAException("Unsupported operation");
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return true;
    }

    KeyRegistry getKeyRegistry() {
        return this.keyRegistry;
    }

    DatastoreService getDatastoreService() {
        return this.datastoreService;
    }

    DatastoreTransaction getCurrentTransaction() {
        return null;
    }

    private static enum State {
        NEW,
        ACTIVE,
        INACTIVE;

    }
}

