/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.expression;

import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;

/**
 * Expression representing a parameter.
 * The parameter can be explicit (declared as input to the query) or implicit (implied based on
 * the syntax in the query).
 */
public class ParameterExpression extends Expression
{
    SymbolTable symtbl;
    String name;
    int position; // Position in the query (when name not specified in execution parameters)
    
    public ParameterExpression(SymbolTable symtbl, String name, int position)
    {
        this.symtbl = symtbl;
        this.name = name;
        this.position = position;
    }

    public String getId()
    {
        return name;
    }

    public int getPosition()
    {
        return position;
    }

    /**
     * Method to bind the expression to the symbol table as appropriate.
     * @return The symbol for this expression
     */
    public Symbol bind()
    {
        if (symtbl.hasSymbol(getId()))
        {
            symbol = symtbl.getSymbol(getId());
        }
        else
        {
            // No symbol for this parameter yet, so add one - type not known
            symbol = new PropertySymbol(getId());
            symtbl.addSymbol(symbol);
        }
        return symbol;
    }

    public String toString()
    {
        return "ParameterExpression{" + name + "}";
    }
}