/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.enhancer.asm.method;

import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.enhancer.asm.ASMClassMethod;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;

/**
 * Method to generate a default Constructor using ASM.
 */
public class DefaultConstructor extends ASMClassMethod
{
    public static DefaultConstructor getInstance(ASMClassEnhancer enhancer)
    {
        return new DefaultConstructor(enhancer, "<init>", Opcodes.ACC_PROTECTED, null, null, null);
    }

    /**
     * Constructor.
     * @param enhancer ClassEnhancer
     * @param name Name of method
     * @param access Access type
     * @param returnType Return type
     * @param argTypes Argument types
     * @param argNames Argument names
     */
    public DefaultConstructor(ClassEnhancer enhancer, String name, int access, 
        Object returnType, Object[] argTypes, String[] argNames)
    {
        super(enhancer, name, access, returnType, argTypes, argNames);
    }

    /**
     * Method to add the contents of the class method.
     */
    public void execute()
    {
        visitor.visitCode();

        Label l0 = new Label();
        visitor.visitLabel(l0);
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        Class superclass = ((ASMClassEnhancer)enhancer).getClassEnhanced().getSuperclass();
        visitor.visitMethodInsn(Opcodes.INVOKESPECIAL, superclass.getName().replace('.', '/'), "<init>", "()V");
        visitor.visitInsn(Opcodes.RETURN);
        Label l1 = new Label();
        visitor.visitLabel(l1);
        visitor.visitLocalVariable("this", getClassEnhancer().getClassDescriptor(), null, l0, l1, 0);
        visitor.visitMaxs(1, 1);

        visitor.visitEnd();
    }

    /**
     * Close the method
     */
    public void close()
    {
        // Override the log message
        if (DataNucleusEnhancer.LOGGER.isDebugEnabled())
        {
            DataNucleusEnhancer.LOGGER.debug(LOCALISER.msg("Enhancer.AddConstructor", getClassEnhancer().className + "()"));
        }
    }
}