/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.tz;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTime;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.LocalDate;
import com.google.appengine.repackaged.org.joda.time.MutableDateTime;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.LenientChronology;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.tz.DateTimeZoneBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ZoneInfoCompiler {
    static DateTimeOfYear cStartOfYear;
    static Chronology cLenientISO;
    static ThreadLocal<Boolean> cVerbose;
    private Map<String, RuleSet> iRuleSets = new HashMap<String, RuleSet>();
    private List<Zone> iZones = new ArrayList<Zone>();
    private List<String> iLinks = new ArrayList<String>();

    public static boolean verbose() {
        return cVerbose.get();
    }

    public static void main(String[] args) throws Exception {
        int i;
        if (args.length == 0) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File inputDir = null;
        File outputDir = null;
        boolean verbose = false;
        for (i = 0; i < args.length; ++i) {
            try {
                if ("-src".equals(args[i])) {
                    inputDir = new File(args[++i]);
                    continue;
                }
                if ("-dst".equals(args[i])) {
                    outputDir = new File(args[++i]);
                    continue;
                }
                if ("-verbose".equals(args[i])) {
                    verbose = true;
                    continue;
                }
                if (!"-?".equals(args[i])) break;
                ZoneInfoCompiler.printUsage();
                return;
            }
            catch (IndexOutOfBoundsException e) {
                ZoneInfoCompiler.printUsage();
                return;
            }
        }
        if (i >= args.length) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File[] sources = new File[args.length - i];
        int j = 0;
        while (i < args.length) {
            sources[j] = inputDir == null ? new File(args[i]) : new File(inputDir, args[i]);
            ++i;
            ++j;
        }
        cVerbose.set(verbose);
        ZoneInfoCompiler zic = new ZoneInfoCompiler();
        zic.compile(outputDir, sources);
    }

    private static void printUsage() {
        System.out.println("Usage: java org.joda.time.tz.ZoneInfoCompiler <options> <source files>");
        System.out.println("where possible options include:");
        System.out.println("  -src <directory>    Specify where to read source files");
        System.out.println("  -dst <directory>    Specify where to write generated files");
        System.out.println("  -verbose            Output verbosely (default false)");
    }

    static DateTimeOfYear getStartOfYear() {
        if (cStartOfYear == null) {
            cStartOfYear = new DateTimeOfYear();
        }
        return cStartOfYear;
    }

    static Chronology getLenientISOChronology() {
        if (cLenientISO == null) {
            cLenientISO = LenientChronology.getInstance(ISOChronology.getInstanceUTC());
        }
        return cLenientISO;
    }

    static void writeZoneInfoMap(DataOutputStream dout, Map<String, DateTimeZone> zimap) throws IOException {
        String id;
        HashMap<String, Short> idToIndex = new HashMap<String, Short>(zimap.size());
        TreeMap<Short, String> indexToId = new TreeMap<Short, String>();
        short count = 0;
        for (Map.Entry<String, DateTimeZone> entry : zimap.entrySet()) {
            Short index;
            id = entry.getKey();
            if (!idToIndex.containsKey(id)) {
                index = count;
                idToIndex.put(id, index);
                indexToId.put(index, id);
                count = (short)(count + 1);
                if (count == 0) {
                    throw new InternalError("Too many time zone ids");
                }
            }
            if (idToIndex.containsKey(id = entry.getValue().getID())) continue;
            index = count;
            idToIndex.put(id, index);
            indexToId.put(index, id);
            if ((count = (short)(count + 1)) != 0) continue;
            throw new InternalError("Too many time zone ids");
        }
        dout.writeShort(indexToId.size());
        for (String id2 : indexToId.values()) {
            dout.writeUTF(id2);
        }
        dout.writeShort(zimap.size());
        for (Map.Entry<String, DateTimeZone> entry : zimap.entrySet()) {
            id = entry.getKey();
            dout.writeShort(((Short)idToIndex.get(id)).shortValue());
            id = entry.getValue().getID();
            dout.writeShort(((Short)idToIndex.get(id)).shortValue());
        }
    }

    static int parseYear(String str, int def) {
        if ((str = str.toLowerCase()).equals("minimum") || str.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (str.equals("maximum") || str.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (str.equals("only")) {
            return def;
        }
        return Integer.parseInt(str);
    }

    static int parseMonth(String str) {
        DateTimeField field = ISOChronology.getInstanceUTC().monthOfYear();
        return field.get(field.set(0L, str, Locale.ENGLISH));
    }

    static int parseDayOfWeek(String str) {
        DateTimeField field = ISOChronology.getInstanceUTC().dayOfWeek();
        return field.get(field.set(0L, str, Locale.ENGLISH));
    }

    static String parseOptional(String str) {
        return str.equals("-") ? null : str;
    }

    static int parseTime(String str) {
        int newPos;
        DateTimeFormatter p = ISODateTimeFormat.hourMinuteSecondFraction();
        MutableDateTime mdt = new MutableDateTime(0L, ZoneInfoCompiler.getLenientISOChronology());
        int pos = 0;
        if (str.startsWith("-")) {
            pos = 1;
        }
        if ((newPos = p.parseInto(mdt, str, pos)) == ~pos) {
            throw new IllegalArgumentException(str);
        }
        int millis = (int)mdt.getMillis();
        if (pos == 1) {
            millis = -millis;
        }
        return millis;
    }

    static char parseZoneChar(char c) {
        switch (c) {
            case 'S': 
            case 's': {
                return 's';
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return 'u';
            }
        }
        return 'w';
    }

    static boolean test(String id, DateTimeZone tz) {
        long prev;
        long next;
        if (!id.equals(tz.getID())) {
            return true;
        }
        long millis = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        long end = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        int offset = tz.getOffset(millis);
        int stdOffset = tz.getStandardOffset(millis);
        String key = tz.getNameKey(millis);
        ArrayList<Long> transitions = new ArrayList<Long>();
        while ((next = tz.nextTransition(millis)) != millis && next <= end) {
            millis = next;
            int nextOffset = tz.getOffset(millis);
            int nextStdOffset = tz.getStandardOffset(millis);
            String nextKey = tz.getNameKey(millis);
            if (offset == nextOffset && stdOffset == nextStdOffset && key.equals(nextKey)) {
                String string = tz.getID();
                String string2 = String.valueOf(new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC()));
                System.out.println(new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append("*d* Error in ").append(string).append(" ").append(string2).toString());
                return false;
            }
            if (nextKey == null || nextKey.length() < 3 && !"??".equals(nextKey)) {
                String string = tz.getID();
                String string3 = String.valueOf(new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC()));
                System.out.println(new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(nextKey).length()).append("*s* Error in ").append(string).append(" ").append(string3).append(", nameKey=").append(nextKey).toString());
                return false;
            }
            transitions.add(millis);
            offset = nextOffset;
            key = nextKey;
        }
        millis = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        end = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        int i = transitions.size();
        while (--i >= 0 && (prev = tz.previousTransition(millis)) != millis && prev >= end) {
            millis = prev;
            long trans = (Long)transitions.get(i);
            if (trans - 1L == millis) continue;
            String string = tz.getID();
            String string4 = String.valueOf(new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC()));
            String string5 = String.valueOf(new DateTime(trans - 1L, (Chronology)ISOChronology.getInstanceUTC()));
            System.out.println(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("*r* Error in ").append(string).append(" ").append(string4).append(" != ").append(string5).toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DateTimeZone> compile(File outputDir, File[] sources) throws IOException {
        DateTimeZone tz;
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                BufferedReader in = new BufferedReader(new FileReader(sources[i]));
                this.parseDataFile(in);
                in.close();
            }
        }
        if (outputDir != null) {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                String i = String.valueOf(outputDir);
                throw new IOException(new StringBuilder(59 + String.valueOf(i).length()).append("Destination directory doesn't exist and cannot be created: ").append(i).toString());
            }
            if (!outputDir.isDirectory()) {
                String i = String.valueOf(outputDir);
                throw new IOException(new StringBuilder(32 + String.valueOf(i).length()).append("Destination is not a directory: ").append(i).toString());
            }
        }
        TreeMap<String, DateTimeZone> map = new TreeMap<String, DateTimeZone>();
        System.out.println("Writing zoneinfo files");
        for (int i = 0; i < this.iZones.size(); ++i) {
            File file;
            DateTimeZone original;
            Zone zone = this.iZones.get(i);
            DateTimeZoneBuilder builder = new DateTimeZoneBuilder();
            zone.addToBuilder(builder, this.iRuleSets);
            tz = original = builder.toDateTimeZone(zone.iName, true);
            if (!ZoneInfoCompiler.test(tz.getID(), tz)) continue;
            map.put(tz.getID(), tz);
            if (outputDir == null) continue;
            if (ZoneInfoCompiler.verbose()) {
                String string = String.valueOf(tz.getID());
                System.out.println(string.length() != 0 ? "Writing ".concat(string) : new String("Writing "));
            }
            if (!(file = new File(outputDir, tz.getID())).getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                builder.writeTo(zone.iName, out);
            }
            FileInputStream in = new FileInputStream(file);
            DateTimeZone tz2 = DateTimeZoneBuilder.readFrom(in, tz.getID());
            ((InputStream)in).close();
            if (original.equals(tz2)) continue;
            String string = tz.getID();
            System.out.println(new StringBuilder(45 + String.valueOf(string).length()).append("*e* Error in ").append(string).append(": Didn't read properly from file").toString());
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i = 0; i < this.iLinks.size(); i += 2) {
                String id = this.iLinks.get(i);
                String alias = this.iLinks.get(i + 1);
                tz = (DateTimeZone)map.get(id);
                if (tz == null) {
                    if (pass <= 0) continue;
                    System.out.println(new StringBuilder(44 + String.valueOf(id).length() + String.valueOf(alias).length()).append("Cannot find time zone '").append(id).append("' to link alias '").append(alias).append("' to").toString());
                    continue;
                }
                map.put(alias, tz);
            }
        }
        if (outputDir != null) {
            System.out.println("Writing ZoneInfoMap");
            File file = new File(outputDir, "ZoneInfoMap");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            try (DataOutputStream dout = new DataOutputStream(out);){
                TreeMap<String, DateTimeZone> zimap = new TreeMap<String, DateTimeZone>(String.CASE_INSENSITIVE_ORDER);
                zimap.putAll(map);
                ZoneInfoCompiler.writeZoneInfoMap(dout, zimap);
            }
        }
        return map;
    }

    public void parseDataFile(BufferedReader in) throws IOException {
        String line;
        Zone zone = null;
        while ((line = in.readLine()) != null) {
            String trimmed = line.trim();
            if (trimmed.length() == 0 || trimmed.charAt(0) == '#') continue;
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (Character.isWhitespace(line.charAt(0)) && st.hasMoreTokens()) {
                if (zone == null) continue;
                zone.chain(st);
                continue;
            }
            if (zone != null) {
                this.iZones.add(zone);
            }
            zone = null;
            if (!st.hasMoreTokens()) continue;
            String token = st.nextToken();
            if (token.equalsIgnoreCase("Rule")) {
                Rule r = new Rule(st);
                RuleSet rs = this.iRuleSets.get(r.iName);
                if (rs == null) {
                    rs = new RuleSet(r);
                    this.iRuleSets.put(r.iName, rs);
                    continue;
                }
                rs.addRule(r);
                continue;
            }
            if (token.equalsIgnoreCase("Zone")) {
                zone = new Zone(st);
                continue;
            }
            if (token.equalsIgnoreCase("Link")) {
                this.iLinks.add(st.nextToken());
                this.iLinks.add(st.nextToken());
                continue;
            }
            String string = String.valueOf(line);
            System.out.println(string.length() != 0 ? "Unknown line: ".concat(string) : new String("Unknown line: "));
        }
        if (zone != null) {
            this.iZones.add(zone);
        }
    }

    static {
        cVerbose = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }

    private static class Zone {
        public final String iName;
        public final int iOffsetMillis;
        public final String iRules;
        public final String iFormat;
        public final int iUntilYear;
        public final DateTimeOfYear iUntilDateTimeOfYear;
        private Zone iNext;

        Zone(StringTokenizer st) {
            this(st.nextToken(), st);
        }

        private Zone(String name, StringTokenizer st) {
            this.iName = name.intern();
            this.iOffsetMillis = ZoneInfoCompiler.parseTime(st.nextToken());
            this.iRules = ZoneInfoCompiler.parseOptional(st.nextToken());
            this.iFormat = st.nextToken().intern();
            int year = Integer.MAX_VALUE;
            DateTimeOfYear dtOfYear = ZoneInfoCompiler.getStartOfYear();
            if (st.hasMoreTokens()) {
                year = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    dtOfYear = new DateTimeOfYear(st);
                }
            }
            this.iUntilYear = year;
            this.iUntilDateTimeOfYear = dtOfYear;
        }

        void chain(StringTokenizer st) {
            if (this.iNext != null) {
                this.iNext.chain(st);
            } else {
                this.iNext = new Zone(this.iName, st);
            }
        }

        public void addToBuilder(DateTimeZoneBuilder builder, Map<String, RuleSet> ruleSets) {
            Zone.addToBuilder(this, builder, ruleSets);
        }

        private static void addToBuilder(Zone zone, DateTimeZoneBuilder builder, Map<String, RuleSet> ruleSets) {
            while (zone != null) {
                builder.setStandardOffset(zone.iOffsetMillis);
                if (zone.iRules == null) {
                    builder.setFixedSavings(zone.iFormat, 0);
                } else {
                    try {
                        int saveMillis = ZoneInfoCompiler.parseTime(zone.iRules);
                        builder.setFixedSavings(zone.iFormat, saveMillis);
                    }
                    catch (Exception e) {
                        RuleSet rs = ruleSets.get(zone.iRules);
                        if (rs == null) {
                            String string = String.valueOf(zone.iRules);
                            throw new IllegalArgumentException(string.length() != 0 ? "Rules not found: ".concat(string) : new String("Rules not found: "));
                        }
                        rs.addRecurring(builder, zone.iFormat);
                    }
                }
                if (zone.iUntilYear == Integer.MAX_VALUE) break;
                zone.iUntilDateTimeOfYear.addCutover(builder, zone.iUntilYear);
                zone = zone.iNext;
            }
        }

        public String toString() {
            String string = this.iName;
            int n = this.iOffsetMillis;
            String string2 = this.iRules;
            String string3 = this.iFormat;
            int n2 = this.iUntilYear;
            String string4 = String.valueOf(this.iUntilDateTimeOfYear);
            String str = new StringBuilder(80 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("[Zone]\nName: ").append(string).append("\nOffsetMillis: ").append(n).append("\nRules: ").append(string2).append("\nFormat: ").append(string3).append("\nUntilYear: ").append(n2).append("\n").append(string4).toString();
            if (this.iNext == null) {
                return str;
            }
            string = this.iNext.toString();
            return new StringBuilder(4 + String.valueOf(str).length() + String.valueOf(string).length()).append(str).append("...\n").append(string).toString();
        }
    }

    private static class RuleSet {
        private List<Rule> iRules = new ArrayList<Rule>();

        RuleSet(Rule rule) {
            this.iRules.add(rule);
        }

        void addRule(Rule rule) {
            if (!rule.iName.equals(this.iRules.get((int)0).iName)) {
                throw new IllegalArgumentException("Rule name mismatch");
            }
            this.iRules.add(rule);
        }

        public void addRecurring(DateTimeZoneBuilder builder, String nameFormat) {
            for (int i = 0; i < this.iRules.size(); ++i) {
                Rule rule = this.iRules.get(i);
                rule.addRecurring(builder, nameFormat);
            }
        }
    }

    private static class Rule {
        public final String iName;
        public final int iFromYear;
        public final int iToYear;
        public final String iType;
        public final DateTimeOfYear iDateTimeOfYear;
        public final int iSaveMillis;
        public final String iLetterS;

        Rule(StringTokenizer st) {
            this.iName = st.nextToken().intern();
            this.iFromYear = ZoneInfoCompiler.parseYear(st.nextToken(), 0);
            this.iToYear = ZoneInfoCompiler.parseYear(st.nextToken(), this.iFromYear);
            if (this.iToYear < this.iFromYear) {
                throw new IllegalArgumentException();
            }
            this.iType = ZoneInfoCompiler.parseOptional(st.nextToken());
            this.iDateTimeOfYear = new DateTimeOfYear(st);
            this.iSaveMillis = ZoneInfoCompiler.parseTime(st.nextToken());
            this.iLetterS = ZoneInfoCompiler.parseOptional(st.nextToken());
        }

        public void addRecurring(DateTimeZoneBuilder builder, String nameFormat) {
            String nameKey = this.formatName(nameFormat);
            this.iDateTimeOfYear.addRecurring(builder, nameKey, this.iSaveMillis, this.iFromYear, this.iToYear);
        }

        private String formatName(String nameFormat) {
            String name;
            int index = nameFormat.indexOf(47);
            if (index > 0) {
                if (this.iSaveMillis == 0) {
                    return nameFormat.substring(0, index).intern();
                }
                return nameFormat.substring(index + 1).intern();
            }
            index = nameFormat.indexOf("%s");
            if (index < 0) {
                return nameFormat;
            }
            String left = nameFormat.substring(0, index);
            String right = nameFormat.substring(index + 2);
            if (this.iLetterS == null) {
                name = left.concat(right);
            } else {
                String string = this.iLetterS;
                name = new StringBuilder(String.valueOf(left).length() + String.valueOf(string).length() + String.valueOf(right).length()).append(left).append(string).append(right).toString();
            }
            return name.intern();
        }

        public String toString() {
            String string = this.iName;
            int n = this.iFromYear;
            int n2 = this.iToYear;
            String string2 = this.iType;
            String string3 = String.valueOf(this.iDateTimeOfYear);
            int n3 = this.iSaveMillis;
            String string4 = this.iLetterS;
            return new StringBuilder(97 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("[Rule]\nName: ").append(string).append("\nFromYear: ").append(n).append("\nToYear: ").append(n2).append("\nType: ").append(string2).append("\n").append(string3).append("SaveMillis: ").append(n3).append("\nLetterS: ").append(string4).append("\n").toString();
        }
    }

    static class DateTimeOfYear {
        public final int iMonthOfYear;
        public final int iDayOfMonth;
        public final int iDayOfWeek;
        public final boolean iAdvanceDayOfWeek;
        public final int iMillisOfDay;
        public final char iZoneChar;

        DateTimeOfYear() {
            this.iMonthOfYear = 1;
            this.iDayOfMonth = 1;
            this.iDayOfWeek = 0;
            this.iAdvanceDayOfWeek = false;
            this.iMillisOfDay = 0;
            this.iZoneChar = (char)119;
        }

        DateTimeOfYear(StringTokenizer st) {
            int month = 1;
            int day = 1;
            int dayOfWeek = 0;
            int millis = 0;
            boolean advance = false;
            int zoneChar = 119;
            if (st.hasMoreTokens()) {
                month = ZoneInfoCompiler.parseMonth(st.nextToken());
                if (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    if (str.startsWith("last")) {
                        day = -1;
                        dayOfWeek = ZoneInfoCompiler.parseDayOfWeek(str.substring(4));
                        advance = false;
                    } else {
                        try {
                            day = Integer.parseInt(str);
                            dayOfWeek = 0;
                            advance = false;
                        }
                        catch (NumberFormatException e) {
                            int index = str.indexOf(">=");
                            if (index > 0) {
                                day = Integer.parseInt(str.substring(index + 2));
                                dayOfWeek = ZoneInfoCompiler.parseDayOfWeek(str.substring(0, index));
                                advance = true;
                            }
                            index = str.indexOf("<=");
                            if (index > 0) {
                                day = Integer.parseInt(str.substring(index + 2));
                                dayOfWeek = ZoneInfoCompiler.parseDayOfWeek(str.substring(0, index));
                                advance = false;
                            }
                            throw new IllegalArgumentException(str);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        str = st.nextToken();
                        zoneChar = ZoneInfoCompiler.parseZoneChar(str.charAt(str.length() - 1));
                        if (str.equals("24:00")) {
                            if (month == 12 && day == 31) {
                                millis = ZoneInfoCompiler.parseTime("23:59:59.999");
                            } else {
                                LocalDate date = day == -1 ? new LocalDate(2001, month, 1).plusMonths(1) : new LocalDate(2001, month, day).plusDays(1);
                                advance = day != -1 && dayOfWeek != 0;
                                month = date.getMonthOfYear();
                                day = date.getDayOfMonth();
                                if (dayOfWeek != 0) {
                                    dayOfWeek = (dayOfWeek - 1 + 1) % 7 + 1;
                                }
                            }
                        } else {
                            millis = ZoneInfoCompiler.parseTime(str);
                        }
                    }
                }
            }
            this.iMonthOfYear = month;
            this.iDayOfMonth = day;
            this.iDayOfWeek = dayOfWeek;
            this.iAdvanceDayOfWeek = advance;
            this.iMillisOfDay = millis;
            this.iZoneChar = (char)zoneChar;
        }

        public void addRecurring(DateTimeZoneBuilder builder, String nameKey, int saveMillis, int fromYear, int toYear) {
            builder.addRecurringSavings(nameKey, saveMillis, fromYear, toYear, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public void addCutover(DateTimeZoneBuilder builder, int year) {
            builder.addCutover(year, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public String toString() {
            int n = this.iMonthOfYear;
            int n2 = this.iDayOfMonth;
            int n3 = this.iDayOfWeek;
            boolean bl = this.iAdvanceDayOfWeek;
            int n4 = this.iMillisOfDay;
            char c = this.iZoneChar;
            return new StringBuilder(133).append("MonthOfYear: ").append(n).append("\nDayOfMonth: ").append(n2).append("\nDayOfWeek: ").append(n3).append("\nAdvanceDayOfWeek: ").append(bl).append("\nMillisOfDay: ").append(n4).append("\nZoneChar: ").append(c).append("\n").toString();
        }
    }
}

