/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EnvUtil;
import com.google.appengine.repackaged.com.google.common.base.Strings;

public class ServiceContext {
    public static final String DEFAULT_API_NAME = "myapi";
    public static final String DEFAULT_APP_NAME = "myapp";
    private final String defaultApiName;
    private final String appHostName;

    public static ServiceContext create() {
        return ServiceContext.create(DEFAULT_APP_NAME, DEFAULT_API_NAME);
    }

    public static ServiceContext create(String applicationId, String apiName) {
        return new ServiceContext(applicationId, apiName);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ServiceContext(String applicationId, String apiName) {
        int colon;
        if (applicationId == null || applicationId.trim().isEmpty()) {
            applicationId = DEFAULT_APP_NAME;
        }
        if ((colon = applicationId.indexOf(":")) >= 0) {
            String appName = applicationId.substring(colon + 1);
            String string = this.defaultApiName = apiName == null ? appName : apiName;
            if (!applicationId.substring(0, colon).equals("google.com")) {
                String string2 = applicationId;
                throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string2).length()).append("Invalid application id '").append(string2).append("'").toString());
            }
            this.appHostName = Strings.isNullOrEmpty(EnvUtil.getAppHostName()) ? String.valueOf(appName).concat(".googleplex.com") : EnvUtil.getAppHostName();
            return;
        }
        String appName = applicationId;
        this.defaultApiName = apiName == null ? appName : apiName;
        this.appHostName = Strings.isNullOrEmpty(EnvUtil.getAppHostName()) ? String.valueOf(applicationId).concat(".appspot.com") : EnvUtil.getAppHostName();
    }

    public String getDefaultApiName() {
        return this.defaultApiName;
    }

    public String getAppHostName() {
        return this.appHostName;
    }

    public String getTransferProtocol() {
        return EnvUtil.isRunningOnAppEngineProd() || !EnvUtil.isRunningOnAppEngine() ? "https" : "http";
    }
}

