/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.scope;

import com.google.api.server.spi.config.scope.AbstractAuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class DisjunctAuthScopeExpression
extends AbstractAuthScopeExpression {
    private final ImmutableList<AbstractAuthScopeExpression> innerExpressions;

    DisjunctAuthScopeExpression(List<AbstractAuthScopeExpression> innerExpressions) {
        this.innerExpressions = ImmutableList.copyOf(innerExpressions);
    }

    @Override
    public String[] getAllScopes() {
        LinkedHashSet<String> allScopes = Sets.newLinkedHashSet();
        for (AuthScopeExpression authScopeExpression : this.innerExpressions) {
            allScopes.addAll(Arrays.asList(authScopeExpression.getAllScopes()));
        }
        return allScopes.toArray(new String[allScopes.size()]);
    }

    @Override
    public boolean isAuthorized(Set<String> userScopes) {
        if (this.innerExpressions.isEmpty()) {
            return false;
        }
        for (AuthScopeExpression authScopeExpression : this.innerExpressions) {
            if (!authScopeExpression.isAuthorized(userScopes)) continue;
            return true;
        }
        return false;
    }

    @Override
    List<String> encode() {
        ArrayList<String> expression = new ArrayList<String>();
        for (AbstractAuthScopeExpression innerExpression : this.innerExpressions) {
            expression.addAll(innerExpression.encode());
        }
        return expression;
    }

    @Override
    public String toLoggingForm() {
        String string = Joiner.on(" || ").join(Iterables.transform(this.innerExpressions, new Function<AuthScopeExpression, String>(this){

            @Override
            public String apply(AuthScopeExpression scopeExpression) {
                return scopeExpression.toLoggingForm();
            }
        }));
        return new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DisjunctAuthScopeExpression)) {
            return false;
        }
        DisjunctAuthScopeExpression that = (DisjunctAuthScopeExpression)obj;
        return this.innerExpressions.equals(that.innerExpressions);
    }

    public int hashCode() {
        return this.innerExpressions.hashCode();
    }
}

