/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.BlobstoreStubServicePb;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.ApiUtils;
import com.google.apphosting.api.ApiProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class PythonServerBlobStorageUtils {
    private PythonServerBlobStorageUtils() {
    }

    static boolean hasBlob(BlobKey blobKey) {
        BlobstoreServicePb.FetchDataRequest request = new BlobstoreServicePb.FetchDataRequest();
        request.setBlobKey(blobKey.getKeyString());
        request.setStartIndex(0L);
        request.setEndIndex(0L);
        try {
            ApiProxy.makeSyncCall((String)"blobstore", (String)"FetchData", (byte[])ApiUtils.convertPbToBytes((Object)request));
        }
        catch (ApiProxy.ApplicationException e) {
            if (e.getApplicationError() == BlobstoreServicePb.BlobstoreServiceError.ErrorCode.BLOB_NOT_FOUND.getValue()) {
                return false;
            }
            throw e;
        }
        return true;
    }

    static OutputStream storeBlob(final BlobKey blobKey) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                BlobstoreStubServicePb.StoreBlobRequest.Builder request = BlobstoreStubServicePb.StoreBlobRequest.newBuilder();
                request.setBlobKey(blobKey.getKeyString());
                request.setContent(ByteString.copyFrom((byte[])this.buf, (int)0, (int)this.count));
                ApiProxy.makeSyncCall((String)"blobstore", (String)"StoreBlob", (byte[])ApiUtils.convertPbToBytes((Object)request.build()));
            }
        };
    }
}

