/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import java.io.Serializable;

@GwtCompatible(serializable=true)
public strictfp final class R2Vector
implements Serializable {
    double x;
    double y;

    public R2Vector() {
        this(0.0, 0.0);
    }

    public R2Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public R2Vector(double[] coord) {
        if (coord.length != 2) {
            throw new IllegalStateException("Points must have exactly 2 coordinates");
        }
        this.x = coord[0];
        this.y = coord[1];
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double get(int index) {
        if (index < 0 || index > 1) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return index == 0 ? this.x : this.y;
    }

    void set(R2Vector v) {
        this.x = v.x();
        this.y = v.y();
    }

    void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static R2Vector add(R2Vector p1, R2Vector p2) {
        return new R2Vector(p1.x + p2.x, p1.y + p2.y);
    }

    public static R2Vector sub(R2Vector p1, R2Vector p2) {
        return new R2Vector(p1.x - p2.x, p1.y - p2.y);
    }

    public static R2Vector mul(R2Vector p, double m) {
        return new R2Vector(m * p.x, m * p.y);
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y;
    }

    public static R2Vector normalize(R2Vector vector) {
        double n = vector.norm();
        if (n != 0.0) {
            return R2Vector.mul(vector, 1.0 / n);
        }
        return new R2Vector(vector.x, vector.y);
    }

    public R2Vector ortho() {
        return new R2Vector(-this.y, this.x);
    }

    public static double dotProd(R2Vector p1, R2Vector p2) {
        return p1.x * p2.x + p1.y * p2.y;
    }

    public double dotProd(R2Vector that) {
        return R2Vector.dotProd(this, that);
    }

    public double crossProd(R2Vector that) {
        return this.x * that.y - this.y * that.x;
    }

    public boolean lessThan(R2Vector that) {
        if (this.x < that.x) {
            return true;
        }
        if (that.x < this.x) {
            return false;
        }
        return this.y < that.y;
    }

    public boolean equals(Object that) {
        if (!(that instanceof R2Vector)) {
            return false;
        }
        R2Vector thatPoint = (R2Vector)that;
        return this.x == thatPoint.x && this.y == thatPoint.y;
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.x));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.y));
        return (int)(value ^ value >>> 32);
    }

    public String toString() {
        double d = this.x;
        double d2 = this.y;
        return new StringBuilder(52).append("(").append(d).append(", ").append(d2).append(")").toString();
    }
}

