/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.store;

import com.google.appengine.repackaged.org.apache.lucene.store.FSLockFactory;
import com.google.appengine.repackaged.org.apache.lucene.store.Lock;
import com.google.appengine.repackaged.org.apache.lucene.store.NativeFSLock;
import java.io.File;
import java.io.IOException;

public class NativeFSLockFactory
extends FSLockFactory {
    public NativeFSLockFactory() throws IOException {
        this((File)null);
    }

    public NativeFSLockFactory(String lockDirName) throws IOException {
        this(new File(lockDirName));
    }

    public NativeFSLockFactory(File lockDir) throws IOException {
        this.setLockDir(lockDir);
    }

    public synchronized Lock makeLock(String lockName) {
        if (this.lockPrefix != null) {
            lockName = this.lockPrefix + "-" + lockName;
        }
        return new NativeFSLock(this.lockDir, lockName);
    }

    public void clearLock(String lockName) throws IOException {
        if (this.lockDir.exists()) {
            File lockFile;
            if (this.lockPrefix != null) {
                lockName = this.lockPrefix + "-" + lockName;
            }
            if ((lockFile = new File(this.lockDir, lockName)).exists() && !lockFile.delete()) {
                throw new IOException("Cannot delete " + lockFile);
            }
        }
    }
}

