/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.util;

public abstract class PriorityQueue {
    private int size;
    private int maxSize;
    protected Object[] heap;

    protected abstract boolean lessThan(Object var1, Object var2);

    protected Object getSentinelObject() {
        return null;
    }

    protected final void initialize(int maxSize) {
        this.size = 0;
        int heapSize = 0 == maxSize ? 2 : (maxSize == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxSize + 1);
        this.heap = new Object[heapSize];
        this.maxSize = maxSize;
        Object sentinel = this.getSentinelObject();
        if (sentinel != null) {
            this.heap[1] = sentinel;
            for (int i = 2; i < this.heap.length; ++i) {
                this.heap[i] = this.getSentinelObject();
            }
            this.size = maxSize;
        }
    }

    public final void put(Object element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
    }

    public final Object add(Object element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
        return this.heap[1];
    }

    public boolean insert(Object element) {
        return this.insertWithOverflow(element) != element;
    }

    public Object insertWithOverflow(Object element) {
        if (this.size < this.maxSize) {
            this.put(element);
            return null;
        }
        if (this.size > 0 && !this.lessThan(element, this.heap[1])) {
            Object ret = this.heap[1];
            this.heap[1] = element;
            this.adjustTop();
            return ret;
        }
        return element;
    }

    public final Object top() {
        return this.heap[1];
    }

    public final Object pop() {
        if (this.size > 0) {
            Object result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap();
            return result;
        }
        return null;
    }

    public final void adjustTop() {
        this.downHeap();
    }

    public final Object updateTop() {
        this.downHeap();
        return this.heap[1];
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int i = this.size;
        Object node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private final void downHeap() {
        int i = 1;
        Object node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }
}

