/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.WriteStats;

final class AutoValue_WriteStats
extends WriteStats {
    private final int indexWrites;
    private final int indexWriteBytes;
    private final int entityWrites;
    private final int entityWriteBytes;
    private final long approximateStorageDelta;
    private final int idSequenceUpdates;
    private final int requestedPuts;
    private final int requestedDeletes;

    private AutoValue_WriteStats(int indexWrites, int indexWriteBytes, int entityWrites, int entityWriteBytes, long approximateStorageDelta, int idSequenceUpdates, int requestedPuts, int requestedDeletes) {
        this.indexWrites = indexWrites;
        this.indexWriteBytes = indexWriteBytes;
        this.entityWrites = entityWrites;
        this.entityWriteBytes = entityWriteBytes;
        this.approximateStorageDelta = approximateStorageDelta;
        this.idSequenceUpdates = idSequenceUpdates;
        this.requestedPuts = requestedPuts;
        this.requestedDeletes = requestedDeletes;
    }

    @Override
    public int indexWrites() {
        return this.indexWrites;
    }

    @Override
    public int indexWriteBytes() {
        return this.indexWriteBytes;
    }

    @Override
    public int entityWrites() {
        return this.entityWrites;
    }

    @Override
    public int entityWriteBytes() {
        return this.entityWriteBytes;
    }

    @Override
    public long approximateStorageDelta() {
        return this.approximateStorageDelta;
    }

    @Override
    public int idSequenceUpdates() {
        return this.idSequenceUpdates;
    }

    @Override
    public int requestedPuts() {
        return this.requestedPuts;
    }

    @Override
    public int requestedDeletes() {
        return this.requestedDeletes;
    }

    public String toString() {
        int n = this.indexWrites;
        int n2 = this.indexWriteBytes;
        int n3 = this.entityWrites;
        int n4 = this.entityWriteBytes;
        long l = this.approximateStorageDelta;
        int n5 = this.idSequenceUpdates;
        int n6 = this.requestedPuts;
        int n7 = this.requestedDeletes;
        return new StringBuilder(254).append("WriteStats{indexWrites=").append(n).append(", indexWriteBytes=").append(n2).append(", entityWrites=").append(n3).append(", entityWriteBytes=").append(n4).append(", approximateStorageDelta=").append(l).append(", idSequenceUpdates=").append(n5).append(", requestedPuts=").append(n6).append(", requestedDeletes=").append(n7).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WriteStats) {
            WriteStats that = (WriteStats)o;
            return this.indexWrites == that.indexWrites() && this.indexWriteBytes == that.indexWriteBytes() && this.entityWrites == that.entityWrites() && this.entityWriteBytes == that.entityWriteBytes() && this.approximateStorageDelta == that.approximateStorageDelta() && this.idSequenceUpdates == that.idSequenceUpdates() && this.requestedPuts == that.requestedPuts() && this.requestedDeletes == that.requestedDeletes();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.indexWrites;
        h$ *= 1000003;
        h$ ^= this.indexWriteBytes;
        h$ *= 1000003;
        h$ ^= this.entityWrites;
        h$ *= 1000003;
        h$ ^= this.entityWriteBytes;
        h$ *= 1000003;
        h$ ^= (int)(this.approximateStorageDelta >>> 32 ^ this.approximateStorageDelta);
        h$ *= 1000003;
        h$ ^= this.idSequenceUpdates;
        h$ *= 1000003;
        h$ ^= this.requestedPuts;
        h$ *= 1000003;
        return h$ ^= this.requestedDeletes;
    }

    @Override
    public WriteStats.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends WriteStats.Builder {
        private Integer indexWrites;
        private Integer indexWriteBytes;
        private Integer entityWrites;
        private Integer entityWriteBytes;
        private Long approximateStorageDelta;
        private Integer idSequenceUpdates;
        private Integer requestedPuts;
        private Integer requestedDeletes;

        Builder() {
        }

        private Builder(WriteStats source) {
            this.indexWrites = source.indexWrites();
            this.indexWriteBytes = source.indexWriteBytes();
            this.entityWrites = source.entityWrites();
            this.entityWriteBytes = source.entityWriteBytes();
            this.approximateStorageDelta = source.approximateStorageDelta();
            this.idSequenceUpdates = source.idSequenceUpdates();
            this.requestedPuts = source.requestedPuts();
            this.requestedDeletes = source.requestedDeletes();
        }

        @Override
        public WriteStats.Builder indexWrites(int indexWrites) {
            this.indexWrites = indexWrites;
            return this;
        }

        @Override
        public WriteStats.Builder indexWriteBytes(int indexWriteBytes) {
            this.indexWriteBytes = indexWriteBytes;
            return this;
        }

        @Override
        public WriteStats.Builder entityWrites(int entityWrites) {
            this.entityWrites = entityWrites;
            return this;
        }

        @Override
        public WriteStats.Builder entityWriteBytes(int entityWriteBytes) {
            this.entityWriteBytes = entityWriteBytes;
            return this;
        }

        @Override
        public WriteStats.Builder approximateStorageDelta(long approximateStorageDelta) {
            this.approximateStorageDelta = approximateStorageDelta;
            return this;
        }

        @Override
        public WriteStats.Builder idSequenceUpdates(int idSequenceUpdates) {
            this.idSequenceUpdates = idSequenceUpdates;
            return this;
        }

        @Override
        public WriteStats.Builder requestedPuts(int requestedPuts) {
            this.requestedPuts = requestedPuts;
            return this;
        }

        @Override
        public WriteStats.Builder requestedDeletes(int requestedDeletes) {
            this.requestedDeletes = requestedDeletes;
            return this;
        }

        @Override
        public WriteStats build() {
            String missing = "";
            if (this.indexWrites == null) {
                missing = String.valueOf(missing).concat(" indexWrites");
            }
            if (this.indexWriteBytes == null) {
                missing = String.valueOf(missing).concat(" indexWriteBytes");
            }
            if (this.entityWrites == null) {
                missing = String.valueOf(missing).concat(" entityWrites");
            }
            if (this.entityWriteBytes == null) {
                missing = String.valueOf(missing).concat(" entityWriteBytes");
            }
            if (this.approximateStorageDelta == null) {
                missing = String.valueOf(missing).concat(" approximateStorageDelta");
            }
            if (this.idSequenceUpdates == null) {
                missing = String.valueOf(missing).concat(" idSequenceUpdates");
            }
            if (this.requestedPuts == null) {
                missing = String.valueOf(missing).concat(" requestedPuts");
            }
            if (this.requestedDeletes == null) {
                missing = String.valueOf(missing).concat(" requestedDeletes");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_WriteStats(this.indexWrites, this.indexWriteBytes, this.entityWrites, this.entityWriteBytes, this.approximateStorageDelta, this.idSequenceUpdates, this.requestedPuts, this.requestedDeletes);
        }
    }
}

