/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyMaskHelper {
    public static PropertyMask convertPathsToMask(Collection<PropertyPath> propertyPaths) {
        HashMap<PropertyName, PropertyMask> nestedMasks = new HashMap<PropertyName, PropertyMask>();
        ArrayListMultimap nestedPaths = ArrayListMultimap.create();
        for (PropertyPath propertyPath : propertyPaths) {
            boolean isEndOfPath;
            PropertyPathSegment segment = propertyPath.segment();
            Preconditions.checkArgument((boolean)(segment instanceof PropertyPathSegment.Member), (Object)"Property mask paths currently support only \".\".");
            PropertyName propertyName = ((PropertyPathSegment.Member)segment).name();
            Preconditions.checkArgument((!propertyName.isKey() ? 1 : 0) != 0, (Object)"__key__ is not supported in a property mask path.");
            PropertyPath propertyPathNext = propertyPath.next();
            boolean bl = isEndOfPath = propertyPathNext == null;
            if (isEndOfPath) {
                nestedMasks.put(propertyName, PropertyMask.FULL);
                nestedPaths.removeAll((Object)propertyName);
                continue;
            }
            if (nestedMasks.containsKey(propertyName)) continue;
            nestedPaths.put((Object)propertyName, (Object)propertyPathNext);
        }
        for (Map.Entry entry : nestedPaths.asMap().entrySet()) {
            PropertyName propertyName = (PropertyName)entry.getKey();
            Collection subPropertyPaths = (Collection)entry.getValue();
            nestedMasks.put(propertyName, PropertyMaskHelper.convertPathsToMask(subPropertyPaths));
        }
        return new PropertyMask(nestedMasks);
    }

    public static ImmutableSet<PropertyPath> convertMaskToPaths(PropertyMask mask) {
        ImmutableSet.Builder paths = ImmutableSet.builder();
        PropertyMaskHelper.convertMaskToPaths(null, mask, (ImmutableSet.Builder<PropertyPath>)paths);
        return paths.build();
    }

    private static void convertMaskToPaths(PropertyPath prefix, PropertyMask mask, ImmutableSet.Builder<PropertyPath> paths) {
        if (mask.equals(PropertyMask.FULL)) {
            if (prefix != null) {
                paths.add((Object)prefix);
            }
        } else {
            for (PropertyName name : mask.propertyNames()) {
                PropertyMaskHelper.convertMaskToPaths(PropertyPath.create(prefix, PropertyPathSegment.Member.create(name)), mask.nestedMask(name), paths);
            }
        }
    }
}

