/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.api.DatastorePb;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_QueryScope;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import javax.annotation.Nullable;

@AutoValue
public abstract class QueryScope {
    @Deprecated
    public abstract PartitionRef partition();

    public String namespace() {
        return this.partition().namespace();
    }

    @Deprecated
    public DatabaseRef databaseRef() {
        return this.partition().databaseRef();
    }

    @Nullable
    public abstract ImmutableList<String> safeReplicaNames();

    @Nullable
    public abstract Long readTimestamp();

    @Nullable
    public abstract Long unrestrictedReadTimestamp();

    public abstract boolean isStrong();

    public abstract boolean isVeryInconsistent();

    @Nullable
    public abstract DatastorePb.Query.Hint hint();

    @Nullable
    public abstract Integer batchSize();

    public static Builder builder() {
        return new AutoValue_QueryScope.Builder().isStrong(false).isVeryInconsistent(false);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder partition(PartitionRef var1);

        public abstract Builder safeReplicaNames(@Nullable Iterable<String> var1);

        public abstract Builder readTimestamp(@Nullable Long var1);

        public abstract Builder unrestrictedReadTimestamp(@Nullable Long var1);

        public abstract Builder isStrong(boolean var1);

        public abstract Builder isVeryInconsistent(boolean var1);

        public abstract Builder hint(@Nullable DatastorePb.Query.Hint var1);

        public abstract Builder batchSize(@Nullable Integer var1);

        abstract QueryScope autoBuild();

        public QueryScope build() {
            QueryScope queryScope = this.autoBuild();
            Preconditions.checkState((queryScope.readTimestamp() == null || queryScope.readTimestamp() > 0L ? 1 : 0) != 0);
            Preconditions.checkState((queryScope.unrestrictedReadTimestamp() == null || queryScope.unrestrictedReadTimestamp() > 0L ? 1 : 0) != 0);
            Preconditions.checkState((queryScope.readTimestamp() == null || queryScope.unrestrictedReadTimestamp() == null ? 1 : 0) != 0, (Object)"The use of readTimestamp and unrestrictedReadTimestamp are mutually exclusive.");
            return queryScope;
        }
    }
}

