/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import javax.annotation.Nullable;

public final class DatabaseRefValidator {
    public static final DatabaseRefValidator INSTANCE = new DatabaseRefValidator();
    private static final ThreadLocal<DatabaseRef> databaseRefThreadLocal = new ThreadLocal<DatabaseRef>(){

        @Override
        protected DatabaseRef initialValue() {
            return null;
        }
    };

    private DatabaseRefValidator() {
    }

    public DatabaseRef validateDatabaseRefMatch(DatabaseRef testDatabase, @Nullable DatabaseRef expectedDatabase) throws ValidationException {
        if (expectedDatabase != null && !testDatabase.equalsIgnoringDirectory(expectedDatabase)) {
            throw new ValidationException(String.format("%s%s vs. %s", "mismatched databases within request: ", testDatabase, expectedDatabase));
        }
        return testDatabase;
    }

    public DatabaseRef createAndValidateDatabaseRef(String appId, String databaseId) throws ValidationException {
        DatabaseRef threadLocalEntry = databaseRefThreadLocal.get();
        if (threadLocalEntry != null && threadLocalEntry.hasAppPartition() && threadLocalEntry.appId().equals(appId) && threadLocalEntry.databaseId().equals(databaseId)) {
            return threadLocalEntry;
        }
        ValidationException.validateAssertion(!appId.isEmpty(), "The app id is the empty string.", new Object[0]);
        if (!databaseId.isEmpty()) {
            ValidationException.validateAssertion(ProjectIds.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        }
        try {
            DatabaseRef databaseRef = DatabaseRef.createForApp(appId, databaseId);
            DatabaseRefValidator.stash(databaseRef);
            return databaseRef;
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(new StringBuilder(24 + String.valueOf(appId).length()).append("\"").append(appId).append("\" is an invalid app id.").toString(), e);
        }
    }

    public static void stash(DatabaseRef databaseRef) {
        databaseRefThreadLocal.set(databaseRef);
    }
}

