/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.org.apache.http.cookie.Cookie;
import com.google.appengine.tools.remoteapi.LoginException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class ClientLogin {
    ClientLogin() {
    }

    @Deprecated
    public List<Cookie> login(String host, String email, String password) throws IOException {
        if (email == null || email.isEmpty()) {
            throw new IllegalArgumentException("email not set");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("password not set");
        }
        List<String[]> postParams = ClientLogin.getClientLoginPostParams(email, password);
        PostResponse authResponse = this.executePost("https://www.google.com/accounts/ClientLogin", postParams);
        String token = this.processAuthResponse(authResponse, email);
        String string = URLEncoder.encode(token, "UTF-8");
        String url = new StringBuilder(51 + String.valueOf(host).length() + String.valueOf(string).length()).append("https://").append(host).append("/_ah/login?auth=").append(string).append("&continue=http://localhost/").toString();
        return this.getAppEngineLoginCookies(url);
    }

    private static List<String[]> getClientLoginPostParams(String email, String password) {
        return Arrays.asList({"Email", email}, {"Passwd", password}, {"service", "ah"}, {"source", "Google-remote_api-java-1.0"}, {"accountType", "HOSTED_OR_GOOGLE"});
    }

    private String processAuthResponse(PostResponse authResponse, String email) throws LoginException {
        if (authResponse.statusCode == 200 || authResponse.statusCode == 403) {
            String info;
            Map<String, String> responseMap = ClientLogin.parseClientLoginResponse(authResponse.body);
            if (authResponse.statusCode == 200) {
                return responseMap.get("Auth");
            }
            String reason = responseMap.get("Error");
            if ("BadAuthentication".equals(reason) && (info = responseMap.get("Info")) != null && !info.isEmpty()) {
                String string = reason;
                reason = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(info).length()).append(string).append(" ").append(info).toString();
            }
            String string = String.valueOf(reason);
            throw new LoginException(string.length() != 0 ? "Login failed. Reason: ".concat(string) : new String("Login failed. Reason: "));
        }
        if (authResponse.statusCode == 401) {
            throw new LoginException(new StringBuilder(35 + String.valueOf(email).length()).append("Email \"").append(email).append("\" and password do not match.").toString());
        }
        int n = authResponse.statusCode;
        throw new LoginException(new StringBuilder(40).append("Bad authentication response: ").append(n).toString());
    }

    private static Map<String, String> parseClientLoginResponse(String body) {
        HashMap<String, String> response = new HashMap<String, String>();
        for (String line : body.split("\n")) {
            int eqIndex = line.indexOf("=");
            if (eqIndex <= 0) continue;
            response.put(line.substring(0, eqIndex), line.substring(eqIndex + 1));
        }
        return response;
    }

    abstract PostResponse executePost(String var1, List<String[]> var2) throws IOException;

    abstract List<Cookie> getAppEngineLoginCookies(String var1) throws IOException;

    static class PostResponse {
        final int statusCode;
        final String body;

        PostResponse(int statusCode, String body) {
            this.statusCode = statusCode;
            this.body = body;
        }
    }
}

