/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.org.apache.http.cookie.Cookie;
import com.google.appengine.repackaged.org.apache.http.entity.ContentType;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.LegacyResponse;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

class HostedAppEngineClient
extends AppEngineClient {
    private final URLFetchService urlFetch = URLFetchServiceFactory.getURLFetchService();

    HostedAppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, String appId) {
        super(options, authCookies, appId);
    }

    private void addCookies(HTTPRequest req) {
        for (Cookie cookie : this.getAuthCookies()) {
            req.addHeader(new HTTPHeader("Cookie", String.format("%s=%s", cookie.getName(), cookie.getValue())));
        }
    }

    @Override
    public AppEngineClient.Response get(String path) throws IOException {
        return HostedAppEngineClient.createResponse(this.doGet(path));
    }

    private HTTPResponse doGet(String path) throws IOException {
        HTTPRequest req = new HTTPRequest(new URL(this.makeUrl(path)), HTTPMethod.GET);
        req.getFetchOptions().doNotFollowRedirects();
        for (String[] headerPair : this.getHeadersForGet()) {
            req.addHeader(new HTTPHeader(headerPair[0], headerPair[1]));
        }
        this.addCookies(req);
        return this.urlFetch.fetch(req);
    }

    @Override
    public AppEngineClient.Response post(String path, String mimeType, byte[] body) throws IOException {
        return HostedAppEngineClient.createResponse(this.doPost(path, mimeType, body));
    }

    private HTTPResponse doPost(String path, String mimeType, byte[] body) throws IOException {
        HTTPRequest req = new HTTPRequest(new URL(this.makeUrl(path)), HTTPMethod.POST);
        req.getFetchOptions().doNotFollowRedirects();
        for (String[] headerPair : this.getHeadersForPost(mimeType)) {
            req.addHeader(new HTTPHeader(headerPair[0], headerPair[1]));
        }
        this.addCookies(req);
        req.setPayload(body);
        return this.urlFetch.fetch(req);
    }

    @Override
    public LegacyResponse legacyGet(String path) throws IOException {
        return HostedAppEngineClient.createLegacyResponse(this.doGet(path));
    }

    @Override
    public LegacyResponse legacyPost(String path, String mimeType, byte[] body) throws IOException {
        return HostedAppEngineClient.createLegacyResponse(this.doPost(path, mimeType, body));
    }

    static AppEngineClient.Response createResponse(HTTPResponse resp) {
        return new AppEngineClient.Response(resp.getResponseCode(), resp.getContent(), HostedAppEngineClient.getCharset(resp));
    }

    static LegacyResponse createLegacyResponse(HTTPResponse resp) {
        return new LegacyResponse(resp.getResponseCode(), resp.getContent(), HostedAppEngineClient.getCharset(resp));
    }

    static Charset getCharset(HTTPResponse resp) {
        for (HTTPHeader header : resp.getHeaders()) {
            if (!header.getName().toLowerCase().equals("content-type")) continue;
            ContentType contentType = ContentType.parse(header.getValue());
            return contentType.getCharset();
        }
        return null;
    }
}

