/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.internal;

import com.google.appengine.api.internal.ImmutableCopy;
import java.util.Collections;
import java.util.List;

public final class Repackaged {
    static final String REPACKAGED_PREFIX = "com.google.appengine.repackaged.";

    private Repackaged() {
    }

    public static <E> List<E> copyIfRepackagedElseOriginal(List<E> list) {
        return Repackaged.isRepackaged(list) ? ImmutableCopy.list(list) : list;
    }

    public static <E> List<E> copyIfRepackagedElseUnmodifiable(List<E> list) {
        return Repackaged.isRepackaged(list) ? ImmutableCopy.list(list) : Collections.unmodifiableList(list);
    }

    public static boolean isRepackaged(Object object) {
        return object != null && object.getClass().getName().startsWith(REPACKAGED_PREFIX);
    }
}

