/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Ticker;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.TimeUnit;

@GoogleInternal
@GwtIncompatible
public class RateObserver {
    private static final Ticker CLOCK = Ticker.systemTicker();
    private final Ticker clock;
    private final double windowSeconds;
    private double tokensAfterCheckpoint = 0.0;
    private long checkpointNanos;
    private double rateOfCheckpointWindow;
    private final Object mutex = new Object();

    public static RateObserver create(long window, TimeUnit unit) {
        return RateObserver.createWithInitialRate(window, unit, 0.0);
    }

    public static RateObserver createWithInitialRate(long window, TimeUnit unit, double startingQps) {
        return new RateObserver(1.0E-9 * (double)unit.toNanos(window), startingQps, CLOCK);
    }

    @VisibleForTesting
    public static RateObserver createForTest(long window, TimeUnit unit, double startingQps, Ticker clock) {
        return new RateObserver(1.0E-9 * (double)unit.toNanos(window), startingQps, clock);
    }

    @VisibleForTesting
    RateObserver(double windowSeconds, double startingQps, Ticker clock) {
        Preconditions.checkNotNull(clock, "clock");
        Preconditions.checkArgument(windowSeconds > 0.0, "windowSeconds [%s] must be > 0", (Object)windowSeconds);
        Preconditions.checkArgument(startingQps >= 0.0, "startingQps [%s] must be >= 0", (Object)startingQps);
        this.clock = clock;
        this.windowSeconds = windowSeconds;
        this.checkpointNanos = clock.read();
        this.rateOfCheckpointWindow = startingQps;
    }

    public double getRate() {
        return this.record(0.0);
    }

    @CanIgnoreReturnValue
    public double record() {
        return this.record(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    public double record(double tokens) {
        Preconditions.checkArgument(tokens >= 0.0, "tokens must be >= 0");
        Object object = this.mutex;
        synchronized (object) {
            long nowNanos = this.clock.read();
            double secondsAfterCheckpoint = 1.0E-9 * (double)(nowNanos - this.checkpointNanos);
            if (secondsAfterCheckpoint >= this.windowSeconds) {
                double silentSeconds = secondsAfterCheckpoint - this.windowSeconds;
                double windowWithObservations = Math.max(0.0, this.windowSeconds - silentSeconds);
                double tokensInLastWindow = tokens + this.tokensAfterCheckpoint * windowWithObservations / this.windowSeconds;
                this.rateOfCheckpointWindow = tokensInLastWindow / this.windowSeconds;
                this.checkpointNanos = nowNanos;
                this.tokensAfterCheckpoint = 0.0;
                secondsAfterCheckpoint = 0.0;
            } else {
                this.tokensAfterCheckpoint += tokens;
            }
            double secondsBeforeCheckpoint = Math.max(this.windowSeconds - secondsAfterCheckpoint, 0.0);
            double tokensBeforeCheckpoint = this.rateOfCheckpointWindow * secondsBeforeCheckpoint;
            return (tokensBeforeCheckpoint + this.tokensAfterCheckpoint) / (secondsAfterCheckpoint + secondsBeforeCheckpoint);
        }
    }
}

