/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class GeneratedExtensionRegistryLoader<T extends ExtensionRegistryLite> {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static String LITE_CLASS_NAME = "com.google.appengine.repackaged.com.google.protobuf.BlazeGeneratedExtensionRegistryLiteLoader";

    GeneratedExtensionRegistryLoader() {
    }

    protected abstract T getInstance();

    static <T extends ExtensionRegistryLite> T load(Class<T> extensionRegistryClass) {
        String wellKnownClassName;
        ClassLoader classLoader = GeneratedExtensionRegistryLoader.class.getClassLoader();
        if (extensionRegistryClass.equals(ExtensionRegistryLite.class)) {
            wellKnownClassName = LITE_CLASS_NAME;
        } else {
            if (!extensionRegistryClass.getPackage().equals(GeneratedExtensionRegistryLoader.class.getPackage())) {
                throw new IllegalArgumentException(extensionRegistryClass.getName());
            }
            wellKnownClassName = String.format("%s.BlazeGenerated%sLoader", extensionRegistryClass.getPackage().getName(), extensionRegistryClass.getSimpleName());
        }
        try {
            GeneratedExtensionRegistryLoader loader;
            Class<?> loaderClass = Class.forName(wellKnownClassName, true, classLoader);
            try {
                loader = (GeneratedExtensionRegistryLoader)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalStateException(nsme);
            }
            catch (InstantiationException ie) {
                throw new IllegalStateException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalStateException(ite);
            }
            return (T)((ExtensionRegistryLite)extensionRegistryClass.cast(loader.getInstance()));
        }
        catch (ClassNotFoundException loaderClass) {
            ServiceLoader<GeneratedExtensionRegistryLoader> loader = ServiceLoader.load(GeneratedExtensionRegistryLoader.class, classLoader);
            Iterator<GeneratedExtensionRegistryLoader> it = loader.iterator();
            ArrayList<T> registries = new ArrayList<T>();
            while (it.hasNext()) {
                try {
                    registries.add(extensionRegistryClass.cast(it.next().getInstance()));
                }
                catch (ServiceConfigurationError e) {
                    String string = String.valueOf(extensionRegistryClass.getSimpleName());
                    logger.logp(Level.SEVERE, "com.google.appengine.repackaged.com.google.protobuf.GeneratedExtensionRegistryLoader", "load", string.length() != 0 ? "Unable to load ".concat(string) : new String("Unable to load "), e);
                }
            }
            if (registries.size() == 1) {
                return (T)((ExtensionRegistryLite)registries.get(0));
            }
            if (registries.size() == 0) {
                return null;
            }
            try {
                return (T)((ExtensionRegistryLite)extensionRegistryClass.getMethod("combine", Collection.class).invoke(null, registries));
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalStateException(nsme);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalStateException(ite);
            }
        }
    }
}

