/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.convert;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.convert.AbstractConverter;
import com.google.appengine.repackaged.org.joda.time.convert.InstantConverter;
import com.google.appengine.repackaged.org.joda.time.convert.PartialConverter;

class ReadableInstantConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final ReadableInstantConverter INSTANCE = new ReadableInstantConverter();

    protected ReadableInstantConverter() {
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone zone) {
        Chronology chrono = ((ReadableInstant)object).getChronology();
        if (chrono == null) {
            return ISOChronology.getInstance(zone);
        }
        DateTimeZone chronoZone = chrono.getZone();
        if (chronoZone != zone && (chrono = chrono.withZone(zone)) == null) {
            return ISOChronology.getInstance(zone);
        }
        return chrono;
    }

    @Override
    public Chronology getChronology(Object object, Chronology chrono) {
        if (chrono == null) {
            chrono = ((ReadableInstant)object).getChronology();
            chrono = DateTimeUtils.getChronology(chrono);
        }
        return chrono;
    }

    @Override
    public long getInstantMillis(Object object, Chronology chrono) {
        return ((ReadableInstant)object).getMillis();
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInstant.class;
    }
}

