/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags.ext;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.LocalDate;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.ISODateTimeFormat;
import javax.annotation.Nullable;

public final class JodaLocalDateFlag
extends Flag<LocalDate> {
    private final DateTimeFormatter format;

    public static JodaLocalDateFlag today(DateTimeZone timeZone) {
        return new JodaLocalDateFlag(new LocalDate(timeZone));
    }

    public static JodaLocalDateFlag yesterday(DateTimeZone timeZone) {
        return new JodaLocalDateFlag(new LocalDate(timeZone).minusDays(1));
    }

    public static JodaLocalDateFlag tomorrow(DateTimeZone timeZone) {
        return new JodaLocalDateFlag(new LocalDate(timeZone).plusDays(1));
    }

    public JodaLocalDateFlag(@Nullable LocalDate defaultValue) {
        this(defaultValue, ISODateTimeFormat.localDateParser());
    }

    public JodaLocalDateFlag(@Nullable LocalDate defaultValue, DateTimeFormatter format) {
        super(defaultValue);
        this.format = format;
    }

    public static JodaLocalDateFlag nullValue() {
        return new JodaLocalDateFlag(null);
    }

    @Override
    protected LocalDate parse(String value) throws InvalidFlagValueException {
        try {
            return this.format.parseDateTime(value).toLocalDate();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagValueException(e.getMessage());
        }
    }

    @Override
    protected String parsableStringValue(LocalDate value) {
        if (this.format.isPrinter()) {
            return this.format.print((ReadablePartial)value);
        }
        return super.parsableStringValue(value);
    }

    public static final class JodaLocalDateFlagFactory {
        public static Flag<LocalDate> value(LocalDate defaultValue) {
            return new JodaLocalDateFlag(defaultValue);
        }

        public static LocalDate valueOf(String value) {
            return JodaLocalDateFlagFactory.parse(DateTimeZone.UTC, value);
        }

        private static LocalDate parse(DateTimeZone tz, String value) {
            if (Strings.isNullOrEmpty(value)) {
                return null;
            }
            if (value.equals("today")) {
                return new LocalDate(tz);
            }
            if (value.equals("yesterday")) {
                return new LocalDate(tz).minusDays(1);
            }
            if (value.equals("tomorrow")) {
                return new LocalDate(tz).plusDays(1);
            }
            return LocalDate.parse((String)value);
        }

        private JodaLocalDateFlagFactory() {
        }
    }
}

