/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.DynamicLatencyAdjuster;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import java.util.Arrays;
import java.util.Random;

class LatencySimulator {
    private static final Random RANDOM = new Random();
    final DynamicLatencyAdjuster adjuster;
    final int[] latencies = new int[100];

    public LatencySimulator(LatencyPercentiles latencyPercentiles) {
        try {
            this.adjuster = latencyPercentiles.dynamicAdjuster().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Arrays.fill(this.latencies, 0, 25, latencyPercentiles.latency25th() != Integer.MAX_VALUE ? latencyPercentiles.latency25th() : latencyPercentiles.latency50th());
        Arrays.fill(this.latencies, 25, 50, latencyPercentiles.latency50th());
        Arrays.fill(this.latencies, 50, 75, latencyPercentiles.latency75th() != Integer.MAX_VALUE ? latencyPercentiles.latency75th() : latencyPercentiles.latency50th());
        Arrays.fill(this.latencies, 75, 95, latencyPercentiles.latency95th() != Integer.MAX_VALUE ? latencyPercentiles.latency95th() : this.latencies[50]);
        Arrays.fill(this.latencies, 95, 100, latencyPercentiles.latency99th() != Integer.MAX_VALUE ? latencyPercentiles.latency99th() : this.latencies[75]);
        this.validate();
    }

    public void simulateLatency(long actualLatencyMs, LocalRpcService service, Object request) {
        long latency = this.adjuster.adjust(service, request, this.latencies[this.nextInt()]);
        if (actualLatencyMs > latency) {
            return;
        }
        this.sleep(latency - actualLatencyMs);
    }

    int nextInt() {
        return RANDOM.nextInt(100);
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while simulating latency.", e);
        }
    }

    private void validate() {
        int last = 0;
        for (int latency : this.latencies) {
            if (latency < last) {
                throw new IllegalArgumentException(String.format("Illegal latency progression - shrank from %d to %d", last, latency));
            }
            last = latency;
        }
    }
}

