/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import java.io.NotSerializableException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.thread.Locker;

class AppEngineSession
extends Session {
    private static final double UPDATE_TIMESTAMP_RATIO = 0.75;

    AppEngineSession(SessionHandler handler, SessionData data) {
        super(handler, data);
    }

    public AppEngineSession(SessionHandler handler, HttpServletRequest request, SessionData data) {
        super(handler, request, data);
    }

    public void setMaxInactiveInterval(int secs) {
        try (Locker.Lock lock = this._lock.lockIfNotHeld();){
            boolean savedDirty = this._sessionData.isDirty();
            super.setMaxInactiveInterval(secs);
            this._sessionData.setDirty(savedDirty);
        }
    }

    protected boolean access(long time) {
        try (Locker.Lock lock = this._lock.lock();){
            long timeRemaining;
            if (this.isValid() && (double)(timeRemaining = this._sessionData.getExpiry() - time) < (double)this._sessionData.getMaxInactiveMs() * 0.75) {
                this._sessionData.setDirty(true);
            }
            boolean bl = super.access(time);
            return bl;
        }
    }

    public void setAttribute(String name, Object value) {
        if (value != null && !(value instanceof Serializable)) {
            throw new RuntimeException(new NotSerializableException(value.getClass().getName()));
        }
        super.setAttribute(name, value);
    }
}

