/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.tools.ClientLibGenerator;
import com.google.appengine.repackaged.com.google.api.client.http.ByteArrayContent;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class CloudClientLibGenerator
implements ClientLibGenerator {
    public static final String BOUNDARY_PREFIX = "----GoogleApisClientBoundary";
    private final String clientLibGenApiUrl;

    public static ClientLibGenerator using(String clientLibGenApiUrl) {
        return new CloudClientLibGenerator(clientLibGenApiUrl);
    }

    @VisibleForTesting
    CloudClientLibGenerator(String clientLibGenApiUrl) {
        this.clientLibGenApiUrl = clientLibGenApiUrl;
    }

    @Override
    public void generateClientLib(String discoveryDoc, String language, String languageVersion, String layout, File file) throws IOException {
        String boundary = this.getBoundary();
        String form = this.createForm(discoveryDoc, language.toLowerCase(), languageVersion, layout, boundary);
        InputStream jar = this.postRequest(this.clientLibGenApiUrl, boundary, form);
        this.copyJar(jar, file);
    }

    @VisibleForTesting
    InputStream postRequest(String url, String boundary, String content) throws IOException {
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
        String string = String.valueOf(boundary);
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(url), ByteArrayContent.fromString(string.length() != 0 ? "multipart/form-data; boundary=".concat(string) : new String("multipart/form-data; boundary="), content));
        request.setReadTimeout(60000);
        HttpResponse response = request.execute();
        if (response.getStatusCode() >= 300) {
            String string2 = String.valueOf(response.getContent());
            throw new IOException(new StringBuilder(41 + String.valueOf(string2).length()).append("Client Generation failed at server side: ").append(string2).toString());
        }
        return response.getContent();
    }

    private String getBoundary() {
        long l = System.currentTimeMillis();
        return new StringBuilder(48).append(BOUNDARY_PREFIX).append(l).toString();
    }

    private String createForm(String content, String lang, String lv, String layout, String boundary) {
        String string = String.valueOf(boundary);
        StringBuilder sb = new StringBuilder(string.length() != 0 ? "--".concat(string) : new String("--"));
        this.addParam(sb, "lang", lang, boundary);
        this.addParam(sb, "lv", lv, boundary);
        this.addParam(sb, "content", content, boundary);
        this.addParam(sb, "layout", layout, boundary);
        return sb.toString();
    }

    private void addParam(StringBuilder sb, String name, String value, String boundary) {
        if (value != null) {
            sb.append("\nContent-Disposition: form-data; name=\"");
            sb.append(name);
            sb.append("\"\n\n");
            sb.append(value);
            sb.append("\n--");
            sb.append(boundary);
        }
    }

    @VisibleForTesting
    void copyJar(InputStream input, File output) throws IOException {
        IoUtil.copy((InputStream)input, (File)output);
    }
}

