/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.util.Iterator;

public class JacksonUtil {
    public static ObjectNode mergeObject(ObjectNode object1, ObjectNode object2) {
        return JacksonUtil.mergeObject(object1, object2, true);
    }

    public static ObjectNode mergeObject(ObjectNode object1, ObjectNode object2, boolean throwOnConflict) {
        Iterator<String> fieldNames = object2.getFieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next();
            JsonNode child2 = object2.get(fieldName);
            JsonNode child1 = object1.get(fieldName);
            JsonNode merged = child1 == null ? child2 : JacksonUtil.mergeNode(child1, child2, throwOnConflict);
            object1.put(fieldName, merged);
        }
        return object1;
    }

    public static ArrayNode mergeArray(ArrayNode array1, ArrayNode array2) {
        array1.addAll(array2);
        return array1;
    }

    public static JsonNode mergeNode(JsonNode node1, JsonNode node2) {
        return JacksonUtil.mergeNode(node1, node2, true);
    }

    public static JsonNode mergeNode(JsonNode node1, JsonNode node2, boolean throwOnConflict) {
        if (node1.isArray()) {
            if (!node2.isArray()) {
                if (throwOnConflict) {
                    String string = String.valueOf(node1);
                    String string2 = String.valueOf(node2);
                    throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Cannot merge array and non-array: ").append(string).append(", ").append(string2).toString());
                }
                return node1;
            }
            return JacksonUtil.mergeArray((ArrayNode)node1, (ArrayNode)node2);
        }
        if (node1.isObject()) {
            if (!node2.isObject()) {
                if (throwOnConflict) {
                    String string = String.valueOf(node1);
                    String string3 = String.valueOf(node2);
                    throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Cannot merge object and non-object: ").append(string).append(", ").append(string3).toString());
                }
                return node1;
            }
            return JacksonUtil.mergeObject((ObjectNode)node1, (ObjectNode)node2, throwOnConflict);
        }
        if (throwOnConflict && !node1.equals(node2)) {
            String string = String.valueOf(node1);
            String string4 = String.valueOf(node2);
            throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Cannot merge different values: ").append(string).append(", ").append(string4).toString());
        }
        return node1;
    }
}

