/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.CloudDiscoveryDocGenerator;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.api.server.spi.tools.devserver.ApiConfig;
import com.google.api.server.spi.tools.devserver.Headers;
import com.google.api.server.spi.tools.devserver.LilyClient;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscoveryService {
    private static final Logger logger = Logger.getLogger(DiscoveryService.class.getName());
    private final List<String> apiConfigSources;
    private Map<String, String> discoveryDocs;
    private final DiscoveryDocGenerator docGenerator = CloudDiscoveryDocGenerator.using("https://webapis-discovery.appspot.com/_ah/api");
    private static final ObjectMapper mapper = ObjectMapperUtil.createStandardObjectMapper();
    private static final String NAME_TO_DISCOVER = "api";
    private static final String VERSION_TO_DISCOVER = "version";
    private static final String FORMAT_TO_DISCOVER = "format";
    private static final ApiConfig discovery = new ApiConfig();
    private static final ApiConfig.Method listMethod = new ApiConfig.Method();
    private static final ApiConfig.Method getMethod = new ApiConfig.Method();

    public static ApiConfig getApiConfig() {
        return discovery;
    }

    public DiscoveryService(List<String> apiConfigSources) {
        this.apiConfigSources = apiConfigSources;
    }

    private static String getDiscoveryDocKey(String apiName, String version, String format) {
        return new StringBuilder(2 + String.valueOf(apiName).length() + String.valueOf(version).length() + String.valueOf(format).length()).append(apiName).append("/").append(version).append("/").append(format).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDiscoveryDocsCached() throws FileNotFoundException, IOException, JsonParseException, JsonMappingException {
        DiscoveryDocGenerator discoveryDocGenerator = this.docGenerator;
        synchronized (discoveryDocGenerator) {
            if (this.discoveryDocs != null) {
                return;
            }
            HashMap<String, String> localDiscoveryDocs = new HashMap<String, String>();
            for (String apiConfigSource : this.apiConfigSources) {
                ApiConfig apiConfig = mapper.readValue(apiConfigSource, ApiConfig.class);
                for (DiscoveryDocGenerator.Format format : DiscoveryDocGenerator.Format.values()) {
                    String key = DiscoveryService.getDiscoveryDocKey(apiConfig.name, apiConfig.version, format.toString().toLowerCase());
                    String doc = this.docGenerator.generateDiscoveryDoc(apiConfigSource, format);
                    localDiscoveryDocs.put(key, doc);
                }
            }
            try {
                String apiDirectory = this.docGenerator.generateApiDirectory(this.apiConfigSources);
                localDiscoveryDocs.put(DiscoveryService.getDiscoveryDocKey("", "", ""), apiDirectory);
            }
            catch (IOException e) {
                logger.logp(Level.WARNING, "com.google.api.server.spi.tools.devserver.DiscoveryService", "ensureDiscoveryDocsCached", "Error getting API directory {0}", e.getMessage());
            }
            this.discoveryDocs = localDiscoveryDocs;
        }
    }

    public LilyClient.Response handle(ApiConfig.Method method, ObjectNode params) throws IOException {
        String apiName = "";
        String version = "";
        String format = "";
        if (method == getMethod) {
            apiName = params.path(NAME_TO_DISCOVER).getTextValue();
            version = params.path(VERSION_TO_DISCOVER).getTextValue();
            format = params.path(FORMAT_TO_DISCOVER).getTextValue();
            if (format == null) {
                format = DiscoveryDocGenerator.Format.REST.toString().toLowerCase();
            }
        } else if (method != listMethod) {
            return null;
        }
        this.ensureDiscoveryDocsCached();
        String key = DiscoveryService.getDiscoveryDocKey(apiName, version, format);
        String discoveryDoc = this.discoveryDocs.get(key);
        if (discoveryDoc == null) {
            logger.logp(Level.WARNING, "com.google.api.server.spi.tools.devserver.DiscoveryService", "handle", "No discovery doc for API {0} version {1} in {2} format", new Object[]{apiName, version, format});
            return new LilyClient.Response(404, new Headers(), "");
        }
        Headers headers = new Headers();
        headers.setContentType("application/json; charset=UTF-8");
        return new LilyClient.Response(200, headers, discoveryDoc);
    }

    static {
        DiscoveryService.discovery.root = null;
        DiscoveryService.discovery.name = "discovery";
        DiscoveryService.discovery.version = "v1";
        DiscoveryService.listMethod.api = discovery;
        DiscoveryService.listMethod.path = "apis";
        DiscoveryService.listMethod.httpMethod = "GET";
        DiscoveryService.listMethod.rosyMethod = "list";
        DiscoveryService.getMethod.api = discovery;
        DiscoveryService.getMethod.path = "apis/{api}/{version}/{format}";
        DiscoveryService.getMethod.httpMethod = "GET";
        DiscoveryService.getMethod.rosyMethod = "get";
        DiscoveryService.discovery.methods.put("discovery.apis.list", listMethod);
        DiscoveryService.discovery.methods.put("discovery.apis.getRest", getMethod);
    }
}

