/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.spi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ServicesFile {
    public static final String SERVICES_PATH = "META-INF/services";

    private ServicesFile() {
    }

    public static String getPath(String serviceName) {
        String string = String.valueOf("META-INF/services/");
        String string2 = String.valueOf(serviceName);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readServiceFile(InputStream input) throws IOException {
        BufferedReader r = null;
        HashSet<String> serviceClasses = new HashSet<String>();
        try {
            String line;
            r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            while ((line = r.readLine()) != null) {
                int commentStart = line.indexOf(35);
                if (commentStart >= 0) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).equals("")) continue;
                serviceClasses.add(line);
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return serviceClasses;
    }

    public static void writeServiceFile(Collection<String> services, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        for (String service : services) {
            writer.write(service);
            writer.newLine();
        }
        writer.flush();
    }
}

