/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.scostore;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.KeyRegistry;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.scostore.AbstractFKStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FKSetStore
extends AbstractFKStore
implements SetStore {
    public FKSetStore(AbstractMemberMetaData ownerMmd, DatastoreManager storeMgr, ClassLoaderResolver clr) {
        super(ownerMmd, storeMgr, clr);
    }

    public boolean hasOrderMapping() {
        return false;
    }

    public boolean add(final ObjectProvider op, Object element, int currentSize) {
        if (element == null) {
            throw new NucleusUserException(LOCALISER.msg("056039"));
        }
        if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            Key parentKey = EntityUtils.getKeyForObject(op.getObject(), op.getExecutionContext());
            KeyRegistry.getKeyRegistry(op.getExecutionContext()).registerParentKeyForOwnedObject(element, parentKey);
        }
        final Object newOwner = op.getObject();
        ExecutionContext ec = op.getExecutionContext();
        boolean inserted = this.validateElementForWriting(ec, element, new FieldValues(){

            public void fetchFields(ObjectProvider esm) {
                JavaTypeMapping externalFKMapping = FKSetStore.this.elementTable.getExternalMapping(FKSetStore.this.ownerMemberMetaData, 5);
                if (externalFKMapping != null) {
                    esm.setAssociatedValue((Object)externalFKMapping, op.getObject());
                }
                if (FKSetStore.this.relationType == 4) {
                    Object currentOwner = esm.provideField(FKSetStore.this.getFieldNumberInElementForBidirectional(esm));
                    if (currentOwner == null) {
                        NucleusLogger.PERSISTENCE.info((Object)AbstractFKStore.LOCALISER.msg("056037", (Object)op.toPrintableID(), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject())));
                        esm.replaceFieldMakeDirty(FKSetStore.this.getFieldNumberInElementForBidirectional(esm), newOwner);
                    } else if (currentOwner != newOwner && op.getReferencedPC() == null) {
                        throw new NucleusUserException(AbstractFKStore.LOCALISER.msg("056038", (Object)op.toPrintableID(), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject()), (Object)StringUtils.toJVMIDString((Object)currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        if (!inserted) {
            ObjectProvider elementOP = ec.findObjectProvider(element);
            if (this.relationType == 4) {
                ec.getApiAdapter().isLoaded(elementOP, this.getFieldNumberInElementForBidirectional(elementOP));
                Object oldOwner = elementOP.provideField(this.getFieldNumberInElementForBidirectional(elementOP));
                if (oldOwner != newOwner) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("055009", (Object)op.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)element)));
                    }
                    int relatedFieldNumber = this.getFieldNumberInElementForBidirectional(elementOP);
                    elementOP.replaceFieldMakeDirty(relatedFieldNumber, newOwner);
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(elementOP).relationChange(relatedFieldNumber, oldOwner, newOwner);
                    }
                    if (ec.isFlushing()) {
                        elementOP.flush();
                    }
                }
                return oldOwner != newOwner;
            }
            if (this.contains(op, element)) {
                return false;
            }
            if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
                EntityUtils.checkParentage(element, op);
                return true;
            }
        }
        return true;
    }

    public boolean addAll(ObjectProvider op, Collection coll, int currentSize) {
        if (coll == null || coll.size() == 0) {
            return false;
        }
        boolean success = false;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (!this.add(op, iter.next(), -1)) continue;
            success = true;
        }
        return success;
    }

    protected boolean deleteElementsOnRemoveOrClear() {
        boolean deleteElements = false;
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056035"));
            deleteElements = true;
        } else if (dependent) {
            deleteElements = true;
        }
        return deleteElements;
    }

    public void clear(ObjectProvider op) {
        boolean deleteElements = this.deleteElementsOnRemoveOrClear();
        ExecutionContext ec = op.getExecutionContext();
        Iterator elementsIter = this.iterator(op);
        if (elementsIter != null) {
            while (elementsIter.hasNext()) {
                Object element = elementsIter.next();
                if (ec.getApiAdapter().isPersistable(element) && ec.getApiAdapter().isDeleted(element)) {
                    ObjectProvider elementSM = ec.findObjectProvider(element);
                    elementSM.flush();
                    continue;
                }
                if (!deleteElements) continue;
                ec.deleteObjectInternal(element);
            }
        }
    }

    public Iterator iterator(ObjectProvider op) {
        ExecutionContext ec = op.getExecutionContext();
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            String propName;
            Entity datastoreEntity = this.getOwnerEntity(op);
            if (datastoreEntity.hasProperty(propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData))) {
                return this.getChildrenFromParentField(op, ec, -1, -1).listIterator();
            }
            if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
                NucleusLogger.PERSISTENCE.info((Object)("Collection at field " + this.ownerMemberMetaData.getFullFieldName() + " of " + op + " not yet migrated to latest storage version, so reading elements via the parent key"));
            }
        }
        if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            ApiAdapter apiAdapter = ec.getApiAdapter();
            Key parentKey = EntityUtils.getPrimaryKeyAsKey(apiAdapter, op);
            return this.getChildrenUsingParentQuery(parentKey, Collections.<Query.FilterPredicate>emptyList(), Collections.<Query.SortPredicate>emptyList(), ec).iterator();
        }
        return Utils.newArrayList(new Object[0]).listIterator();
    }

    public boolean remove(ObjectProvider op, Object element, int currentSize, boolean allowCascadeDelete) {
        if (element == null) {
            return false;
        }
        if (!this.validateElementForReading(op.getExecutionContext(), element)) {
            return false;
        }
        Object elementToRemove = element;
        ExecutionContext ec = op.getExecutionContext();
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        ObjectProvider elementOP = ec.findObjectProvider(elementToRemove);
        if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            Object oldOwner = null;
            if (this.relationType == 4 && !ec.getApiAdapter().isDeleted(elementToRemove)) {
                int elemOwnerFieldNumber = this.getFieldNumberInElementForBidirectional(elementOP);
                ec.getApiAdapter().isLoaded(elementOP, elemOwnerFieldNumber);
                oldOwner = elementOP.provideField(elemOwnerFieldNumber);
            }
            if (Relation.isBidirectional((int)this.relationType) && oldOwner != op.getObject() && oldOwner != null) {
                return false;
            }
        }
        boolean deleteElements = this.deleteElementsOnRemoveOrClear();
        if (ec.getApiAdapter().isPersistable(elementToRemove) && ec.getApiAdapter().isDeleted(elementToRemove)) {
            elementOP.flush();
        } else if (deleteElements) {
            ec.deleteObjectInternal(elementToRemove);
        }
        return true;
    }

    public boolean removeAll(ObjectProvider op, Collection coll, int currentSize) {
        if (coll == null || coll.size() == 0) {
            return false;
        }
        boolean success = true;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (!this.remove(op, iter.next(), -1, true)) continue;
            success = false;
        }
        return success;
    }

    public void update(ObjectProvider op, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(op);
            return;
        }
        Iterator elemIter = this.iterator(op);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(op, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(op, elem, 0);
            }
        }
    }

    protected int getFieldNumberInElementForBidirectional(ObjectProvider elementOP) {
        AbstractMemberMetaData[] relMmds;
        if (Relation.isBidirectional((int)this.relationType) && (relMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)) != null) {
            return relMmds[0].getAbsoluteFieldNumber();
        }
        return -1;
    }
}

