/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class FileIterator
implements Iterator<File>,
Iterable<File> {
    private LinkedList<File> dirs = new LinkedList();
    private Iterator<File> files;
    private File next;

    public FileIterator(File base) {
        File[] baseFiles = base.listFiles();
        if (baseFiles != null) {
            this.files = Arrays.asList(baseFiles).iterator();
        }
        this._next();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public File next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this._next();
    }

    private File _next() {
        File result = this.next;
        this.next = null;
        while (this.files != null) {
            try {
                File f = this.files.next();
                if (f.isDirectory()) {
                    this.dirs.add(f);
                    continue;
                }
                this.next = f;
                break;
            }
            catch (NoSuchElementException ex) {
                if (this.dirs.isEmpty()) {
                    this.files = null;
                    continue;
                }
                this.files = Arrays.asList(this.dirs.removeFirst().listFiles()).iterator();
            }
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<File> iterator() {
        return this;
    }
}

