package javax.persistence;

public interface Result
{
    /**
     * Get the value of the specified result item.
     * @param resultItem result list item
     * @return value of result list item
     * @throws IllegalArgument exception if result item does not correspond to an item in the query result
     */
    <X> X get(ResultItem<X> resultItem);

    /**
     * Get the value of the result list item to which the
     * specified alias has been assigned.
     * @param alias alias assigned to result list item
     * @return type of the result list item
     * @throws IllegalArgument exception if alias does not correspond to an item in the query result 
     *     or type is incorrect
     */
    <X> X get(String alias, Class<X> type);

    /**
     * Get the value of the item at the specified
     * position in the result list. The first position is 0.
     * @param i position in result list
     * @param type type of the result list item
     * @return value of the result list item
     * @throws IllegalArgument exception if i exceeds length of result list of type is incorrect
     */
    <X> X get(int i, Class<X> type);

    /**
     * Get the value of the item at the specified
     * position in the result list. The first position is 0.
     * @param i position in result list
     * @return value of the result item
     * @throws IllegalArgument exception if i exceeds length of result list
     */
    Object get(int i);

    /**
     * Return the values of the result list items as an array.
     * @return result list values
     */
    Object[] toArray();
}