/**********************************************************************
Copyright (c) 2004 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.metadata;

/**
 * Representation of the Meta-Data for a container.
 * This is subclassed by Array, Collection, and Map.
 */
public class ContainerMetaData extends MetaData
{
    /**
     * Constructor.
     */
    public ContainerMetaData()
    {
    }

    /**
     * Accessor for the parent field/property MetaData.
     * @return Parent metadata
     */
    public AbstractMemberMetaData getMemberMetaData()
    {
        if (parent != null)
        {
            return (AbstractMemberMetaData)parent;
        }
        return null;
    }

    /**
     * Accessor for the parent field name
     * @return Parent field name.
     */
    public String getFieldName()
    {
        if (parent != null)
        {
            return ((AbstractMemberMetaData)parent).getName();
        }
        return null;
    }

    /**
     * Accessor for the MetaDataManager of the file.
     * @return MetaDataManager.
     */
    public MetaDataManager getMetaDataManager()
    {
        if (parent != null)
        {
            return getMemberMetaData().getAbstractClassMetaData().getMetaDataManager();
        }
        return null;
    }
}