/**********************************************************************
Copyright (c) 2005 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Representation of a metadata string literal.
 */
public class MetaDataStringLiteral extends StringLiteral
{
    /** Column name DataNucleus uses for MetaData information (containing the class name of that row). */
    public static final String QUERY_META_DATA = "NUCLEUS_TYPE";

    /**
     * Constructor
     * @param qs The QueryExpression
     * @param value The metadata value
     */
    public MetaDataStringLiteral(QueryExpression qs, String value)
    {
        super(qs, qs.getStoreManager().getMappingManager().getMapping(String.class), value);
        as(QUERY_META_DATA);
    }
}