/**********************************************************************
Copyright (c) 2002 Mike Martin and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.util.Localiser;

/**
 * A <tt>TableMismatchException</tt> is thrown if the query statement generator
 * attempts to reference a column in a table expression but the column's table
 * is not present in the expression, nor can it be sensibly joined to the
 * expression.
 * This indicates a bug in the query statement generator.
 *
 * @see org.datanucleus.store.mapped.expression.LogicSetExpression
 * @version $Revision: 1.11 $ 
 */
public class TableMismatchException extends NucleusException
{
    protected static final Localiser LOCALISER=Localiser.getInstance("org.datanucleus.Localisation",
        ObjectManagerFactoryImpl.class.getClassLoader());

    /**
     * Constructs a table mismatch exception.
     *
     * @param column    The column that was being referenced.
     * @param mainTable The main table of the table expression.
     */
    public TableMismatchException(DatastoreField column, DatastoreContainerObject mainTable)
    {
        super(LOCALISER.msg("020002",column.getIdentifier(),mainTable,column.getDatastoreContainerObject()));
        setFatal();
    }
}