/**********************************************************************
Copyright (c) 2007 Thomas Marti and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import java.awt.Polygon;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;

/**
 * Mapping for java.awt.Polygon, maps the points to int-precision datastore fields.
 */
public class PolygonMapping extends SingleFieldMultiMapping
{

    private static final Polygon sampleValue = new Polygon();

	/* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#initialize()
     */
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr)
    {
		super.initialize(dba, fmd, container, clr);

//		String typeName = ClassNameConstants.INT_ARRAY;
//		ArrayMapping arrayMapping = new ArrayMapping();
//		arrayMapping.initialize(dba, fmd, container, clr);
//		
//        MappingManager mgr = dba.getMappingManager();
//        DatastoreField column = mgr.createDatastoreField(arrayMapping, typeName, getNumberOfDatastoreFields());
//        DatastoreMapping datastoreMapping =  mgr.createDatastoreMapping(arrayMapping, datastoreContainer.getStoreManager(), column, typeName);

		addDatastoreField(ClassNameConstants.INT_ARRAY); // X-Points
        addDatastoreField(ClassNameConstants.INT_ARRAY); // Y-Points
        addDatastoreField(ClassNameConstants.INT); // Npoints
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getJavaType()
     */
    public Class getJavaType()
    {
        return Polygon.class;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getSampleValue()
     */
    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return sampleValue;
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#setObject(org.datanucleus.ObjectManager, java.lang.Object, int[], java.lang.Object)
     */
    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value)
    {
    	Polygon poly = (Polygon)value;
        if (poly == null)
        {
            getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
            getDataStoreMapping(1).setObject(preparedStatement, exprIndex[1], null);
            getDataStoreMapping(2).setObject(preparedStatement, exprIndex[2], null);
        }
        else
        {
            getDataStoreMapping(0).setObject(preparedStatement,exprIndex[0],poly.xpoints);
            getDataStoreMapping(1).setObject(preparedStatement,exprIndex[1],poly.ypoints);
            getDataStoreMapping(2).setInt(preparedStatement,exprIndex[2],poly.npoints);
        }
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getObject(org.datanucleus.ObjectManager, java.lang.Object, int[])
     */
    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex)
    {
        // Check for null entries
        if (getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null)
        {
            return null;
        }

        int[] xpoints = (int[])getDataStoreMapping(0).getObject(resultSet,exprIndex[0]); 
        int[] ypoints = (int[])getDataStoreMapping(1).getObject(resultSet,exprIndex[1]); 
        int npoints = getDataStoreMapping(2).getInt(resultSet,exprIndex[2]); 
        return new Polygon(xpoints, ypoints, npoints);
    }
}