/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    Andy Jefferson - coding standards and javadocs
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import java.sql.Timestamp;
import java.util.Date;

import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

/**
 * SCO Mapping for java.util.Date type.
 */
public class DateMapping extends SqlTimestampMapping
{
    public ScalarExpression newLiteral(QueryExpression qs, Object value)
    {
        return super.newLiteral(qs, new Timestamp(((Date)value).getTime()));
    }

    public Class getJavaType()
    {
        return Date.class;
    }

    /**
     * Method to return the default length of this type in the datastore.
     * java.util.Date requires 28 characters ("dow mon dd hh:mm:ss zzz yyyy")
     * @param index The index position
     * @return The default length
     */
    public int getDefaultLength(int index)
    {
        return 28;
    }
}