/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchBar;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.util.Array;
import org.basex.util.FTToken;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.ByteList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class TextEditor {
    private static final char[] ALLOWED = new char[]{':', '-'};
    private static final String OPENING = "{([";
    private static final String CLOSING = "})]";
    IntList[] searchResults = new IntList[]{new IntList(), new IntList()};
    int start = -1;
    int end = -1;
    int error = -1;
    private final GUI gui;
    private SearchContext searchContext;
    private Thread searchThread;
    private byte[] text = Token.EMPTY;
    private int lines = -1;
    private int pos;

    TextEditor(GUI gui) {
        this.gui = gui;
    }

    boolean text(byte[] txt) {
        if (Token.eq(txt, this.text)) {
            return false;
        }
        int tl = txt.length;
        this.text = txt;
        this.lines = -1;
        this.noSelect();
        this.search(this.searchContext, false);
        if (this.pos > tl) {
            this.pos = tl;
        }
        return true;
    }

    void search(SearchContext sc, boolean jump) {
        if (sc == null) {
            return;
        }
        Thread t = this.searchThread;
        if (t != null) {
            t.interrupt();
        }
        t = new Thread(() -> {
            try {
                this.searchResults = sc.search(this.text, jump);
                this.searchContext = sc;
                this.searchThread = null;
            }
            catch (JobException ex) {
                Util.debug(ex);
            }
            catch (Exception ex) {
                String info = Util.message(ex).replaceAll(Text.NL + ".*", "");
                this.gui.status.setText(Text.REGULAR_EXPR + ": " + info, false);
            }
        });
        t.setDaemon(true);
        t.start();
        this.searchThread = t;
    }

    int[] replace(ReplaceContext rc) {
        int ts = this.size();
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        boolean sel = this.isSelected();
        if (sel) {
            int p = s - 1;
            while (++p < e && this.text[p] != 10) {
            }
            boolean bl = sel = p < e;
        }
        if (!sel) {
            s = 0;
            e = ts;
        }
        return rc.replace(this.searchContext, this.text, s, e);
    }

    int lines() {
        if (this.lines == -1) {
            int c = 1;
            for (byte ch : this.text) {
                if (ch != 10) continue;
                ++c;
            }
            this.lines = c;
        }
        return this.lines;
    }

    private void forward(boolean select) {
        if (select || !this.isSelected()) {
            this.next();
        } else {
            this.pos(Math.max(this.start, this.end));
        }
    }

    void next(boolean select) {
        if (select && !this.isSelected()) {
            this.startSelect();
        }
        this.forward(select);
        if (select) {
            this.endSelection();
        }
    }

    void previous(boolean select) {
        if (select && !this.isSelected()) {
            this.startSelect();
        }
        this.back(select);
        if (select) {
            this.endSelection();
        }
    }

    void nextWord(boolean select) {
        if (select && !this.isSelected()) {
            this.startSelect();
        }
        int ch = this.curr();
        this.forward(select);
        if (ch != 10) {
            if (FTToken.lod(ch)) {
                while (FTToken.lod(ch)) {
                    ch = this.next();
                }
            } else if (!FTToken.ws(ch)) {
                while (ch != 10 && !FTToken.lod(ch) && !FTToken.ws(ch)) {
                    ch = this.next();
                }
            }
            while (ch != 10 && FTToken.ws(ch)) {
                ch = this.next();
            }
            if (this.pos != this.size()) {
                this.prev();
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    void prevWord(boolean select) {
        int ch;
        if (select && !this.isSelected()) {
            this.startSelect();
        }
        if ((ch = this.back(select)) != 10) {
            if (FTToken.lod(ch)) {
                while (FTToken.lod(ch)) {
                    ch = this.prev();
                }
            } else if (FTToken.ws(ch)) {
                while (ch != 10 && FTToken.ws(ch)) {
                    ch = this.prev();
                }
                while (FTToken.lod(ch)) {
                    ch = this.prev();
                }
            } else {
                while (ch != 10 && !FTToken.lod(ch) && !FTToken.ws(ch)) {
                    ch = this.prev();
                }
            }
            if (this.pos != 0) {
                this.next();
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    int completionStart() {
        int p;
        for (p = this.pos; p > 0 && TextEditor.completeMore(this.text[p - 1]); --p) {
        }
        return p;
    }

    private static boolean completeMore(byte ch) {
        if (Token.letterOrDigit(ch)) {
            return true;
        }
        for (char a : ALLOWED) {
            if (ch != a) continue;
            return true;
        }
        return false;
    }

    void textStart(boolean select) {
        this.startSelection(select);
        this.pos = 0;
        if (select) {
            this.endSelection();
        }
    }

    void textEnd(boolean select) {
        this.startSelection(select);
        this.pos = this.size();
        if (select) {
            this.endSelection();
        }
    }

    public byte[] text() {
        return this.text;
    }

    private int indent() {
        return Math.max(1, this.gui.gopts.get(GUIOptions.INDENT));
    }

    private byte[] spaces() {
        byte[] spaces;
        if (this.gui.gopts.get(GUIOptions.TABSPACES).booleanValue()) {
            spaces = new byte[this.indent()];
            Arrays.fill(spaces, (byte)32);
        } else {
            spaces = new byte[]{9};
        }
        return spaces;
    }

    private int bol(boolean select) {
        if (this.pos == 0) {
            if (!select) {
                this.noSelect();
            }
            return 0;
        }
        int ind = this.indent();
        int c = 0;
        do {
            c += this.curr() == 9 ? ind : 1;
        } while (this.back(select) != 10);
        if (this.pos != 0 || this.curr() == 10) {
            this.forward(select);
        }
        return c;
    }

    void lineStart(boolean select) {
        if (select && !this.isSelected()) {
            this.startSelect();
        }
        int p = this.pos;
        boolean s = true;
        while (this.back(select) != 10) {
            s &= FTToken.ws(this.curr());
        }
        if (this.pos != 0 || this.curr() == 10) {
            this.forward(select);
        }
        if (p == this.pos || !s) {
            while (FTToken.ws(this.curr()) && this.curr() != 10) {
                this.forward(select);
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    void lineEnd(boolean select) {
        this.startSelection(select);
        this.forward(Integer.MAX_VALUE, select);
        if (select) {
            this.endSelection();
        }
    }

    private int back(boolean select) {
        if (select || !this.isSelected()) {
            return this.prev();
        }
        this.pos(Math.min(this.start, this.end));
        return this.curr();
    }

    private int prev() {
        if (this.pos == 0) {
            return 10;
        }
        while (--this.pos > 0 && this.text[this.pos] < -64) {
        }
        return this.curr();
    }

    private void forward(int p, boolean select) {
        int ind = this.indent();
        int nc = 0;
        while (this.curr() != 10) {
            if ((nc += this.curr() == 9 ? ind : 1) >= p) {
                return;
            }
            this.forward(select);
        }
    }

    int linesUp(int l, boolean select, int lastCol) {
        this.startSelection(select);
        int col = this.bol(select);
        if (this.pos() == 0) {
            col = -1;
        } else {
            if (lastCol != -1) {
                col = lastCol;
            }
            for (int i = 0; i < l; ++i) {
                this.back(select);
                this.bol(select);
            }
            this.forward(col, select);
        }
        if (select) {
            this.endSelection();
        }
        return col;
    }

    int linesDown(int l, boolean select, int lastCol) {
        this.startSelection(select);
        int lc = lastCol == -1 ? this.bol(select) : lastCol;
        for (int i = 0; i < l; ++i) {
            this.forward(Integer.MAX_VALUE, select);
            this.forward(select);
        }
        this.forward(lc, select);
        if (this.pos() == this.size()) {
            lc = -1;
        }
        if (select) {
            this.endSelection();
        }
        return lc;
    }

    void insert(String str) {
        int cl = str.length();
        TokenBuilder tb = new TokenBuilder(cl);
        for (int c = 0; c < cl; ++c) {
            int ch = str.charAt(c);
            if (ch == 13 || ch < 32 && !Token.ws(ch)) continue;
            if (Character.isHighSurrogate((char)ch) && c + 1 < cl) {
                ch = Character.toCodePoint((char)ch, str.charAt(++c));
            }
            tb.add(ch);
        }
        this.insert(tb.finish(), this.pos, this.pos);
        this.pos += tb.size();
    }

    boolean comment(Syntax syntax) {
        int off;
        byte[] st = syntax.commentOpen();
        byte[] en = syntax.commentEnd();
        byte[] ste = Token.concat(st, Token.cpToken(32));
        byte[] ene = Token.concat(Token.cpToken(32), en);
        int sl = st.length;
        int el = en.length;
        int sle = ste.length;
        int ele = ene.length;
        if (!this.isSelected()) {
            this.start = this.pos;
            this.end = this.pos;
            while (this.start > 0 && this.text[this.start - 1] != 10) {
                --this.start;
            }
            while (this.end < this.size() && this.text[this.end] != 10) {
                ++this.end;
            }
        } else if (this.start > this.end) {
            int s = this.start;
            this.start = this.end;
            this.end = s;
        }
        while (this.start < this.end && Token.ws(this.text[this.start])) {
            ++this.start;
        }
        while (this.end > this.start && Token.ws(this.text[this.end - 1])) {
            --this.end;
        }
        int min = this.start;
        int max = this.end;
        if (this.isSelected() && this.text[max - 1] == 10) {
            --max;
        }
        TokenBuilder tb = new TokenBuilder();
        int mx = Math.max(min + sl, max - el);
        int mxe = Math.max(min + sle, max - ele);
        if (Token.indexOf(this.text, ste, min) == min && Token.indexOf(this.text, ene, mxe) == mxe) {
            tb.add(this.text, min + sle, max - ele);
            off = -sle - ele;
        } else if (Token.indexOf(this.text, st, min) == min && Token.indexOf(this.text, en, mx) == mx) {
            tb.add(this.text, min + sl, max - el);
            off = -sl - el;
        } else {
            tb.add(ste).add(this.text, min, max).add(ene);
            off = sle + ele;
        }
        boolean added = this.insert(tb.finish(), min, max);
        this.select(min, max + off);
        return added;
    }

    private boolean insert(byte[] string, int offset, int rem) {
        int ts = this.size();
        ByteList bl = new ByteList(offset + string.length + ts - rem);
        bl.add(this.text, 0, offset).add(string).add(this.text, rem, ts);
        return this.text(bl.finish());
    }

    boolean toCase(Case cs) {
        if (!this.isSelected()) {
            return false;
        }
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        int d = this.size() - e;
        byte[] tmp = Token.substring(this.text, s, e);
        TokenBuilder tb = new TokenBuilder(this.size());
        tb.add(this.text, 0, s);
        tb.add(cs == Case.LOWER ? Token.lc(tmp) : (cs == Case.UPPER ? Token.uc(tmp) : Token.tc(tmp)));
        tb.add(this.text, e, this.size());
        boolean changed = this.text(tb.finish());
        this.select(s, this.size() - d);
        return changed;
    }

    int bracket() {
        IntList parentheses = new IntList();
        int cp = this.curr();
        int opening = OPENING.indexOf(cp);
        int closing = CLOSING.indexOf(cp);
        if (opening != -1) {
            parentheses.add(opening);
            while (this.pos() < this.size() && !parentheses.isEmpty()) {
                this.next();
                cp = this.curr();
                opening = OPENING.indexOf(cp);
                closing = CLOSING.indexOf(cp);
                if (opening != -1) {
                    parentheses.add(opening);
                    continue;
                }
                if (closing != parentheses.peek()) continue;
                parentheses.pop();
            }
        } else if (closing != -1) {
            parentheses.add(closing);
            while (this.pos() > 0 && !parentheses.isEmpty()) {
                cp = this.prev();
                opening = OPENING.indexOf(cp);
                closing = CLOSING.indexOf(cp);
                if (closing != -1) {
                    parentheses.add(closing);
                    continue;
                }
                if (opening != parentheses.peek()) continue;
                parentheses.pop();
            }
        } else {
            while (this.pos() > 0) {
                cp = this.prev();
                opening = OPENING.indexOf(cp);
                closing = CLOSING.indexOf(cp);
                if (opening != -1) {
                    if (!parentheses.isEmpty()) {
                        if (opening != parentheses.peek()) continue;
                        parentheses.pop();
                        continue;
                    }
                    break;
                }
                if (closing == -1) continue;
                parentheses.add(closing);
            }
        }
        return this.pos;
    }

    void move(boolean down) {
        if (!this.extend()) {
            return;
        }
        int s = this.start;
        int e = this.end;
        int ts = this.size();
        byte[] tmp = Arrays.copyOf(this.text, ts);
        if (down) {
            int i;
            if (e == ts) {
                return;
            }
            this.pos = e;
            this.lineEnd(true);
            int c = s;
            for (i = e; i < this.pos; ++i) {
                tmp[c++] = this.text[i];
            }
            tmp[c++] = 10;
            for (i = s; i < e - 1; ++i) {
                tmp[c++] = this.text[i];
            }
            this.text(tmp);
            this.select(s + this.pos - e + 1, Math.min(ts, this.pos + 1));
        } else {
            int i;
            if (s == 0) {
                return;
            }
            this.pos = s - 1;
            this.bol(true);
            int c = this.pos;
            for (i = s; i < e; ++i) {
                tmp[c++] = this.text[i];
            }
            if (tmp[c - 1] != 10) {
                tmp[c++] = 10;
            }
            for (i = this.pos; i < s && c < ts; ++i) {
                tmp[c++] = this.text[i];
            }
            this.text(tmp);
            this.select(this.pos, this.pos + e - s);
        }
    }

    void complete(String value, int p) {
        int ind;
        String v = value;
        int car = v.indexOf(95);
        if (car != -1) {
            v = v.replace("_", "");
        }
        if ((ind = this.open()) != 0) {
            v = new TokenBuilder().addAll(v.split("\n"), "\n" + " ".repeat(ind)).toString();
        }
        this.replace(p, this.pos, v);
        if (car != -1) {
            this.pos = p + car;
        }
    }

    boolean format(Syntax syntax) {
        boolean sel = this.isSelected();
        int s = sel ? Math.min(this.start, this.end) : 0;
        int e = sel ? Math.max(this.start, this.end) : this.size();
        byte[] format = syntax.format(Arrays.copyOfRange(this.text, s, e), this.spaces());
        boolean changed = this.insert(format, s, e);
        this.select(s, s + format.length);
        return changed;
    }

    boolean sort() {
        int i;
        if (!this.isSelected()) {
            this.selectAll();
        }
        if (!this.extend()) {
            return false;
        }
        int l = 1;
        int s = this.start;
        int e = this.end;
        int ts = this.size();
        byte[] tmp = Arrays.copyOf(this.text, ts);
        for (int i2 = s; i2 < e; ++i2) {
            if (tmp[i2] != 10) continue;
            ++l;
        }
        TokenList tl = new TokenList(l);
        ByteList bl = new ByteList();
        for (i = s; i < e; ++i) {
            byte ch = tmp[i];
            if (ch == 10) {
                tl.add(bl.next());
                continue;
            }
            bl.add(ch);
        }
        if (!bl.isEmpty()) {
            tl.add(bl.finish());
        }
        this.sort(tl);
        i = s;
        for (byte[] line : tl) {
            int ll = line.length;
            Array.copyFromStart(line, ll, tmp, i);
            if ((i += ll) >= e) continue;
            tmp[i++] = 10;
        }
        if (i < e) {
            Array.copy(tmp, e, ts - e, tmp, i);
        }
        boolean changed = this.text(i == e ? tmp : Arrays.copyOf(tmp, ts - e + i));
        this.select(s, i);
        return changed;
    }

    private void sort(TokenList tokens) {
        Comparator cc;
        GUIOptions gopts = this.gui.gopts;
        boolean unicode = gopts.get(GUIOptions.UNICODE);
        int column = gopts.get(GUIOptions.COLUMN) - 1;
        if (!unicode || column > 0) {
            tokens.sort(true, true);
        }
        if (!unicode) {
            Collator coll = Collator.getInstance();
            cc = (t1, t2) -> coll.compare(Token.string(TextEditor.sub(t1, column)), Token.string(TextEditor.sub(t2, column)));
        } else {
            cc = gopts.get(GUIOptions.CASESORT) != false ? (t1, t2) -> Token.compare(TextEditor.sub(t1, column), TextEditor.sub(t2, column)) : (t1, t2) -> Token.compare(Token.lc(TextEditor.sub(t1, column)), Token.lc(TextEditor.sub(t2, column)));
        }
        tokens.sort(cc, (boolean)gopts.get(GUIOptions.ASCSORT));
        if (gopts.get(GUIOptions.MERGEDUPL).booleanValue()) {
            tokens.unique();
        }
    }

    private static byte[] sub(byte[] token, int column) {
        int tl = token.length;
        int t = 0;
        for (int c = 0; t < tl && c < column; t += Token.cl(token, t), ++c) {
        }
        return Token.substring(token, t);
    }

    boolean indent(StringBuilder sb, boolean shift) {
        if (!this.isSelected() && shift && this.size() != 0) {
            this.selectLine();
        }
        if (this.isSelected()) {
            this.indent(shift);
            sb.setLength(0);
            return this.isSelected();
        }
        if (shift) {
            sb.setLength(0);
        } else {
            boolean c = this.pos > 0;
            for (int p = this.pos - 1; p >= 0 && c; --p) {
                byte b = this.text[p];
                if (!Token.ws(b)) {
                    return false;
                }
                if (b == 10) break;
            }
            sb.setLength(0);
            sb.append(Token.string(this.spaces()));
        }
        return false;
    }

    int enter(StringBuilder sb) {
        boolean opening = this.pos > 0 && OPENING.indexOf(this.text[this.pos - 1]) != -1;
        boolean closing = this.pos < this.size() && CLOSING.indexOf(this.text[this.pos]) != -1;
        int ind = this.indent();
        int indent = this.open();
        int move = 0;
        if (opening) {
            if (closing) {
                sb.append(" ".repeat(Math.max(0, indent + ind)));
                move = indent + ind + 1;
                sb.append('\n');
            } else {
                indent += ind;
            }
        } else if (closing) {
            indent -= ind;
        }
        sb.append(" ".repeat(Math.max(0, indent)));
        this.add(sb, false);
        return move;
    }

    int add(StringBuilder sb, boolean selected) {
        if (sb.isEmpty()) {
            return 0;
        }
        int move = 0;
        if (!selected && this.gui.gopts.get(GUIOptions.AUTO).booleanValue()) {
            char ch = sb.charAt(0);
            byte next = this.pos + 1 < this.size() ? this.text[this.pos + 1] : (byte)0;
            byte curr = this.pos < this.size() ? this.text[this.pos] : (byte)0;
            byte prev = this.pos > 0 ? this.text[this.pos - 1] : (byte)0;
            byte pprv = this.pos > 1 ? this.text[this.pos - 2] : (byte)0;
            int opening = OPENING.indexOf(ch);
            if (opening != -1) {
                if (CLOSING.indexOf(curr) != -1 || curr == 0 || Token.ws(curr) || curr == 60) {
                    sb.append(CLOSING.charAt(opening));
                    move = 1;
                }
            } else if (CLOSING.indexOf(ch) != -1) {
                if (ch == curr) {
                    sb.setLength(0);
                    move = 1;
                }
                this.close();
            } else if (ch == '\"' || ch == '\'') {
                if (ch == curr) {
                    sb.setLength(0);
                } else if (!XMLToken.isNCChar(prev) && !XMLToken.isNCChar(curr)) {
                    sb.append(ch);
                }
                move = 1;
            } else if (ch == '>') {
                this.closeElem(sb);
                move = 1;
            } else if (ch == ':') {
                if (prev == 40) {
                    sb.append(':');
                    if (curr != 41) {
                        sb.append(')');
                    }
                    move = 1;
                }
            } else if (ch == '~') {
                if (prev == 58 && pprv == 40) {
                    sb.append("  ");
                    if (curr != 58) {
                        sb.append(':');
                        if (curr != 41) {
                            sb.append(')');
                        }
                    } else if (next != 41) {
                        sb.append(')');
                    }
                    move = 2;
                }
            } else if (ch == '-') {
                if (prev == 45 && pprv == 33 && this.pos > 2 && this.text[this.pos - 3] == 60) {
                    sb.append("  -->");
                    move = 2;
                }
            } else if (ch == '?' && prev == 60) {
                sb.append(" ?>");
                move = 1;
            }
        }
        this.insert(sb.toString());
        return move;
    }

    private void close() {
        byte b;
        int p;
        for (p = this.pos - 1; p >= 0 && (b = this.text[p]) != 10; --p) {
            if (Token.ws(b)) continue;
            return;
        }
        if (++p >= this.pos) {
            return;
        }
        this.start = Math.max(this.pos - this.indent(), p);
        this.end = Math.max(this.pos, p);
        if (this.start != this.end) {
            this.delete();
        }
    }

    private void closeElem(StringBuilder sb) {
        int p = this.pos;
        while (this.pos() > 0) {
            int cp = this.prev();
            if (XMLToken.isNCChar(cp) || cp == 58) continue;
            if (cp != 60 || this.pos >= p - 1) break;
            this.next();
            sb.append("</").append(Token.string(this.text, this.pos, p - this.pos)).append('>');
            break;
        }
        this.pos = p;
    }

    void deletePrev() {
        if (!this.isSelected()) {
            if (this.pos == 0) {
                return;
            }
            this.startSelect();
            int curr = this.curr();
            int prev = this.prev();
            this.endSelection();
            if (this.gui.gopts.get(GUIOptions.AUTO).booleanValue()) {
                if (curr == prev && (curr == 34 || curr == 39)) {
                    ++this.start;
                } else {
                    int open = OPENING.indexOf(prev);
                    if (open != -1 && CLOSING.indexOf(curr) == open) {
                        ++this.start;
                    }
                }
            }
        }
        this.del();
    }

    void delete() {
        if (!this.isSelected()) {
            if (this.pos == this.size()) {
                return;
            }
            this.start = this.pos;
            this.end = this.pos + Token.cl(this.text, this.pos);
        }
        this.del();
    }

    private void del() {
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        int ts = this.size();
        this.text(new ByteList(ts - e + s).add(this.text, 0, s).add(this.text, e, ts).finish());
        this.pos = s;
    }

    void deleteLines() {
        this.extend();
        this.delete();
    }

    void duplLines() {
        int p = this.pos;
        int s = this.start;
        int e = this.end;
        this.extend();
        String selected = this.selected();
        if (selected.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.end > 0 && this.text[this.end - 1] != 10) {
            sb.append('\n');
        }
        this.pos = this.end;
        this.insert(sb.append(selected).toString());
        this.pos = p;
        this.start = s;
        this.end = e;
    }

    void deleteNext(boolean word) {
        if (!this.isSelected()) {
            if (this.pos() == this.size()) {
                return;
            }
            this.startSelect();
            if (word) {
                this.nextWord(true);
            } else {
                this.lineEnd(true);
            }
            this.endSelection();
        }
        this.delete();
    }

    void deletePrev(boolean word) {
        if (!this.isSelected()) {
            if (this.pos() == 0) {
                return;
            }
            this.startSelect();
            if (word) {
                this.prevWord(true);
            } else {
                this.bol(true);
            }
            this.endSelection();
        }
        this.delete();
    }

    private void replace(int s, int e, String value) {
        this.select(s, e);
        this.delete();
        this.insert(value);
    }

    private boolean extend() {
        int s;
        if (!this.isSelected()) {
            this.selectLine();
            if (!this.isSelected()) {
                return false;
            }
        }
        int e = Math.max(this.start, this.end);
        int ts = this.size();
        for (s = Math.min(this.start, this.end); s > 0 && this.text[s - 1] != 10; --s) {
        }
        if (e > 0) {
            while (e < ts && this.text[e - 1] != 10) {
                ++e;
            }
        }
        this.start = s;
        this.end = e;
        return true;
    }

    private void indent(boolean shift) {
        if (!this.extend()) {
            return;
        }
        int s = this.start;
        int e = this.end;
        int ind = this.indent();
        byte[] spaces = this.spaces();
        TokenBuilder tb = new TokenBuilder();
        for (int p = s; p < e; ++p) {
            if (p == 0 || this.text[p - 1] == 10) {
                int c;
                int i = 0;
                do {
                    byte cp;
                    if ((cp = this.text[p]) == 9) {
                        i += ind;
                        continue;
                    }
                    if (cp != 32) break;
                    ++i;
                } while (++p < e);
                i = shift ? Math.max(0, i - ind) : i + ind;
                for (c = 0; c < i / ind; ++c) {
                    tb.add(spaces);
                }
                for (c = 0; c < i % ind; ++c) {
                    tb.add(32);
                }
            }
            if (p >= e) continue;
            tb.addByte(this.text[p]);
        }
        this.insert(tb.finish(), s, e);
        this.select(s, s + tb.size());
    }

    private int open() {
        byte b;
        int ind = this.indent();
        int indent = 0;
        for (int p = this.pos - 1; p >= 0 && (b = this.text[p]) != 10; --p) {
            if (b == 9) {
                indent += ind;
                continue;
            }
            if (b == 32) {
                ++indent;
                continue;
            }
            indent = 0;
        }
        return indent;
    }

    int size() {
        return this.text.length;
    }

    int pos() {
        return this.pos;
    }

    void pos(int p) {
        this.pos = p;
        this.noSelect();
    }

    void noSelect() {
        this.start = -1;
        this.end = -1;
    }

    void select(int p, boolean select) {
        this.pos = p;
        if (select) {
            this.startSelect();
        } else {
            this.end = this.pos;
        }
    }

    void selectAll() {
        this.select(0, this.size());
    }

    void select(int s, int e) {
        this.start = s;
        this.end = e;
        this.pos = e;
        this.checkSelection();
    }

    void startSelection(boolean select) {
        if (select) {
            if (!this.isSelected()) {
                this.startSelect();
            }
        } else {
            this.noSelect();
        }
    }

    void endSelection() {
        this.end = this.pos;
        this.checkSelection();
    }

    private void checkSelection() {
        if (this.start == this.end) {
            this.noSelect();
        }
    }

    boolean isSelected() {
        return this.start != this.end;
    }

    String selected() {
        int s;
        int e = Math.max(this.start, this.end);
        TokenBuilder tb = new TokenBuilder(e - s);
        for (s = Math.min(this.start, this.end); s < e; s += Token.cl(this.text, s)) {
            int cp = Token.cp(this.text, s);
            if ((cp < 32 || cp >= 57344) && cp != 10 && cp != 9 && cp <= 63743) continue;
            tb.add(cp);
        }
        return tb.toString();
    }

    void selectWord() {
        int cp;
        boolean ch = FTToken.lod(this.curr());
        while (this.pos() > 0) {
            cp = this.back(true);
            if (cp != 10 && ch == FTToken.lod(cp)) continue;
            this.forward(true);
            break;
        }
        this.startSelect();
        while (this.pos() < this.size() && (cp = this.curr()) != 10 && ch == FTToken.lod(cp)) {
            this.forward(true);
        }
        this.endSelection();
    }

    void selectLine() {
        this.bol(false);
        this.startSelect();
        this.forward(Integer.MAX_VALUE, true);
        this.next();
        this.endSelection();
    }

    private int curr() {
        return this.pos < 0 || this.pos >= this.size() ? 10 : Token.cp(this.text, this.pos);
    }

    private int next() {
        int c = this.curr();
        if (this.pos < this.size()) {
            this.pos += Token.cl(this.text, this.pos);
        }
        return c;
    }

    private void startSelect() {
        this.start = this.pos;
        this.end = this.pos;
    }

    void error(int s) {
        this.error = s;
    }

    int jump(SearchBar.SearchDir dir, boolean select) {
        if (this.searchResults[0].isEmpty()) {
            if (select) {
                this.noSelect();
            }
            return -1;
        }
        int s = this.searchResults[0].sortedIndexOf(!select || this.isSelected() ? this.pos : this.pos - 1);
        s = switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case SearchBar.SearchDir.CURRENT -> {
                if (s < 0) {
                    yield -s - 1;
                }
                yield s;
            }
            case SearchBar.SearchDir.FORWARD -> {
                if (s < 0) {
                    yield -s - 1;
                }
                yield s + 1;
            }
            case SearchBar.SearchDir.BACKWARD -> s < 0 ? -s - 2 : s - 1;
        };
        int sl = this.searchResults[0].size();
        if (s < 0) {
            s = sl - 1;
        } else if (s == sl) {
            s = 0;
        }
        int p = this.searchResults[0].get(s);
        if (select) {
            this.start = this.searchResults[1].get(s);
            this.end = p;
        }
        this.pos = p;
        return p;
    }

    public static enum Case {
        LOWER,
        UPPER,
        TITLE;

    }
}

