/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.Union;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnError;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.Types;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public abstract class Logical
extends Arr {
    Logical(InputInfo info, Expr[] exprs) {
        super(info, Types.BOOLEAN_O, exprs);
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            this.exprs[e] = cc.compileOrError(this.exprs[e], e == 0);
        }
        return this.optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        this.flatten(cc);
        this.exprs = this.simplifyAll(CompileContext.Simplify.EBV, cc);
        boolean or = this.or();
        if (this.optimizeEbv(or, false, cc)) {
            return cc.replaceWith(this, Bln.get(or));
        }
        int el = this.exprs.length;
        if (el == 0) {
            return Bln.get(!or);
        }
        if (el == 1) {
            return cc.function(Function.BOOLEAN, this.info, this.exprs);
        }
        return this;
    }

    @Override
    public final Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public final boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        boolean or = this.or();
        for (Expr expr : this.exprs) {
            if (expr.test(qc, this.info, 0L) != or) continue;
            return or;
        }
        return !or;
    }

    @Override
    public final boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            if (ii.costs.results() == 0) {
                if (this.or()) continue;
                return true;
            }
            costs = IndexCosts.add(costs, ii.costs);
            list.add(ii.expr);
        }
        ii.costs = costs;
        ii.expr = list.size() == 1 ? (Expr)list.get(0) : (this.or() ? new Union(this.info, (Expr[])list.finish()) : new Intersect(this.info, (Expr[])list.finish())).optimize(ii.cc);
        return true;
    }

    abstract boolean or();

    @Override
    public final void markTailCalls(CompileContext cc) {
        Expr last = this.exprs[this.exprs.length - 1];
        if (last.seqType().eq(Types.BOOLEAN_O)) {
            last.markTailCalls(cc);
        }
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            try {
                Expr inlined = this.exprs[e].inline(ic);
                if (inlined == null) continue;
                this.exprs[e] = inlined;
                changed = true;
                continue;
            }
            catch (QueryException ex) {
                if (e == 0) {
                    throw ex;
                }
                Expr[] nw = new Expr[e + 1];
                Array.copy(this.exprs, e, nw);
                nw[e] = FnError.get(ex, this.exprs[e]);
                this.exprs = nw;
                changed = true;
                break;
            }
        }
        return changed ? this.optimize(ic.cc) : null;
    }
}

