/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.util.Enums;
import org.basex.util.InputInfo;

public class FnSortBy
extends StandardFunc {
    private static final Str KEY = Str.get("key");
    private static final Str COLLATION = Str.get("collation");
    private static final Str ORDER = Str.get("order");

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.iter(this.arg(0).value(qc), qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        return input.seqType().zero() ? input : this.adoptType(input);
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode == CompileContext.Simplify.COUNT ? this.arg(0) : this, mode);
    }

    Iter iter(Value input, QueryContext qc) throws QueryException {
        if (input.isEmpty()) {
            return input.iter();
        }
        long is = input.size();
        ItemList list = new ItemList(is);
        for (Item item : input) {
            list.add(item);
        }
        Value[] values = (Item[])list.finish();
        Integer[] index = this.index(values, qc);
        return FnSortBy.sorted(index) ? input.iter() : new BasicIter<Item>(is, (Item[])values, index){
            final /* synthetic */ Item[] val$values;
            final /* synthetic */ Integer[] val$index;
            {
                this.val$values = itemArray;
                this.val$index = integerArray;
                super(size);
            }

            @Override
            public Item get(long l) {
                return this.val$values[this.val$index[(int)l]];
            }
        };
    }

    protected static boolean sorted(Integer[] index) {
        int il = index.length;
        for (int i = 0; i < il; ++i) {
            if (index[i] == i) continue;
            return false;
        }
        return true;
    }

    protected Integer[] index(Value[] values, QueryContext qc) throws QueryException {
        Value maps = this.arg(1).value(qc);
        if (maps.isEmpty()) {
            maps = XQMap.empty();
        }
        int ms = (int)maps.size();
        FItem[] keys = new FItem[ms];
        Collation[] collations = new Collation[ms];
        boolean[] invert = new boolean[ms];
        int m = 0;
        for (Item item : maps) {
            XQMap map = this.toMap(item);
            if (map.contains(KEY)) {
                keys[m] = this.toFunction(map.get(KEY), 1, qc);
            }
            collations[m] = this.toCollation(map.get(COLLATION), qc);
            if (map.contains(ORDER)) {
                invert[m] = this.toEnum(map.get(ORDER).item(qc, this.info), Order.class) == Order.DESCENDING;
            }
            ++m;
        }
        return this.index(values, keys, collations, invert, qc);
    }

    protected final Integer[] index(Value[] values, FItem[] keys, Collation[] collations, boolean[] invert, QueryContext qc) throws QueryException {
        int levels = keys.length;
        int size = values.length;
        Value[][] cached = new Value[levels][];
        for (int l = 0; l < levels; ++l) {
            cached[l] = new Value[size];
        }
        Integer[] indexes = new Integer[size];
        for (int o = 0; o < size; ++o) {
            indexes[o] = o;
        }
        try {
            Arrays.sort(indexes, (i1, i2) -> {
                qc.checkStop();
                try {
                    for (int l = 0; l < levels; ++l) {
                        int ll = l;
                        QueryFunction<Integer, Value> value = i -> {
                            Value val = cached[ll][i];
                            if (val == null) {
                                FItem k = keys[ll];
                                cached[ll][i.intValue()] = val = (k == null ? values[i] : k.invoke(qc, this.info, values[i])).atomValue(qc, this.info);
                            }
                            return val;
                        };
                        int diff = FnSortBy.compare(value.apply((Integer)i1), value.apply((Integer)i2), collations[l], this.info);
                        if (diff == 0) continue;
                        return invert[l] ? -diff : diff;
                    }
                    return 0;
                }
                catch (QueryException ex) {
                    throw new QueryRTException(ex);
                }
            });
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        return indexes;
    }

    static int compare(Value value1, Value value2, Collation collation, InputInfo info) throws QueryException {
        long size1 = value1.size();
        long size2 = value2.size();
        long il = Math.min(size1, size2);
        int i = 0;
        while ((long)i < il) {
            Item item2;
            Item item1 = value1.itemAt(i);
            if (!item1.comparable(item2 = value2.itemAt(i))) {
                throw QueryError.compareError(item1, item2, info);
            }
            int diff = item1.compare(item2, collation, true, info);
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return Long.signum(size1 - size2);
    }

    private static enum Order {
        ASCENDING,
        DESCENDING;


        public String toString() {
            return Enums.string(this);
        }
    }
}

