/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.Arrays;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.value.Value;
import org.basex.query.value.array.PartialLeafNode;
import org.basex.util.Array;
import org.basex.util.Util;

final class LeafNode
implements Node<Value, Value> {
    final Value[] values;

    LeafNode(Value[] values) {
        this.values = values;
        assert (values.length >= 8 && values.length <= 15);
    }

    @Override
    public long size() {
        return this.values.length;
    }

    public LeafNode reverse() {
        int n = this.values.length;
        Value[] out = new Value[n];
        for (int i = 0; i < n; ++i) {
            out[i] = this.values[n - 1 - i];
        }
        return new LeafNode(out);
    }

    public LeafNode set(long pos, Value value) {
        Value[] vals = (Value[])this.values.clone();
        vals[(int)pos] = value;
        return new LeafNode(vals);
    }

    @Override
    public boolean insert(Node<Value, Value>[] siblings, long pos, Value value) {
        int p = (int)pos;
        int n = this.values.length;
        Value[] vals = new Value[n + 1];
        Array.copy(this.values, p, vals);
        vals[p] = value;
        Array.copy(this.values, p, n - p, vals, p + 1);
        if (n < 15) {
            siblings[1] = new LeafNode(vals);
            return false;
        }
        LeafNode left = (LeafNode)siblings[0];
        if (left != null && left.values.length < 15) {
            Value[] lvals = left.values;
            int l = lvals.length;
            int diff = 15 - l;
            int move = (diff + 1) / 2;
            Value[] newLeft = new Value[l + move];
            Value[] newRight = new Value[n + 1 - move];
            Array.copy(lvals, l, newLeft);
            Array.copyFromStart(vals, move, newLeft, l);
            Array.copyToStart(vals, move, newRight.length, newRight);
            siblings[0] = new LeafNode(newLeft);
            siblings[1] = new LeafNode(newRight);
            return false;
        }
        LeafNode right = (LeafNode)siblings[2];
        if (right != null && right.values.length < 15) {
            Value[] rvals = right.values;
            int r = rvals.length;
            int diff = 15 - r;
            int move = (diff + 1) / 2;
            int l = n + 1 - move;
            Value[] newLeft = new Value[l];
            Value[] newRight = new Value[r + move];
            Array.copy(vals, l, newLeft);
            Array.copyToStart(vals, l, move, newRight);
            Array.copyFromStart(rvals, r, newRight, move);
            siblings[1] = new LeafNode(newLeft);
            siblings[2] = new LeafNode(newRight);
            return false;
        }
        int l = vals.length / 2;
        int r = vals.length - l;
        Value[] newLeft = new Value[l];
        Value[] newRight = new Value[r];
        Array.copy(vals, l, newLeft);
        Array.copyToStart(vals, l, r, newRight);
        siblings[3] = siblings[2];
        siblings[1] = new LeafNode(newLeft);
        siblings[2] = new LeafNode(newRight);
        return true;
    }

    @Override
    public NodeLike<Value, Value>[] remove(Node<Value, Value> left, Node<Value, Value> right, long pos) {
        int p = (int)pos;
        int n = this.values.length;
        NodeLike[] out = new NodeLike[]{left, null, right};
        if (n > 8) {
            Value[] vals = new Value[n - 1];
            Array.copy(this.values, p, vals);
            Array.copy(this.values, p + 1, n - 1 - p, vals, p);
            out[1] = new LeafNode(vals);
            return out;
        }
        LeafNode leftLeaf = (LeafNode)left;
        if (leftLeaf != null && leftLeaf.arity() > 8) {
            Value[] lvals = leftLeaf.values;
            int l = lvals.length;
            int diff = l - 8;
            int move = (diff + 1) / 2;
            int ll = l - move;
            int rl = n - 1 + move;
            Value[] newLeft = new Value[ll];
            Value[] newRight = new Value[rl];
            Array.copy(lvals, ll, newLeft);
            Array.copyToStart(lvals, ll, move, newRight);
            Array.copyFromStart(this.values, p, newRight, move);
            Array.copy(this.values, p + 1, n - 1 - p, newRight, move + p);
            out[0] = new LeafNode(newLeft);
            out[1] = new LeafNode(newRight);
            return out;
        }
        LeafNode rightLeaf = (LeafNode)right;
        if (rightLeaf != null && rightLeaf.arity() > 8) {
            Value[] rvals = rightLeaf.values;
            int r = rvals.length;
            int diff = r - 8;
            int move = (diff + 1) / 2;
            int ll = n - 1 + move;
            int rl = r - move;
            Value[] newLeft = new Value[ll];
            Value[] newRight = new Value[rl];
            Array.copy(this.values, p, newLeft);
            Array.copy(this.values, p + 1, n - 1 - p, newLeft, p);
            Array.copyFromStart(rvals, move, newLeft, n - 1);
            Array.copyToStart(rvals, move, rl, newRight);
            out[1] = new LeafNode(newLeft);
            out[2] = new LeafNode(newRight);
            return out;
        }
        if (left != null) {
            Value[] lvals = ((LeafNode)left).values;
            int l = lvals.length;
            int r = this.values.length;
            Value[] vals = new Value[l + r - 1];
            Array.copy(lvals, l, vals);
            Array.copyFromStart(this.values, p, vals, l);
            Array.copy(this.values, p + 1, r - 1 - p, vals, l + p);
            out[0] = new LeafNode(vals);
            return out;
        }
        if (right != null) {
            Value[] rvals = ((LeafNode)right).values;
            int l = this.values.length;
            int r = rvals.length;
            Value[] vals = new Value[l - 1 + r];
            Array.copy(this.values, p, vals);
            Array.copy(this.values, p + 1, l - 1 - p, vals, p);
            Array.copyFromStart(rvals, r, vals, l - 1);
            out[2] = new LeafNode(vals);
            return out;
        }
        Value[] vals = new Value[n - 1];
        Array.copy(this.values, p, vals);
        Array.copy(this.values, p + 1, n - 1 - p, vals, p);
        out[1] = new PartialLeafNode(vals);
        return out;
    }

    @Override
    public int append(NodeLike<Value, Value>[] nodes, int pos) {
        if (pos == 0) {
            nodes[0] = this;
            return 1;
        }
        NodeLike<Value, Value> left = nodes[pos - 1];
        if (!(left instanceof PartialLeafNode)) {
            nodes[pos] = this;
            return pos + 1;
        }
        Value[] ls = ((PartialLeafNode)left).elems;
        int l = ls.length;
        Value[] rs = this.values;
        int r = rs.length;
        int n = l + r;
        if (n <= 15) {
            Value[] vals = new Value[n];
            Array.copy(ls, l, vals);
            Array.copyFromStart(rs, r, vals, l);
            nodes[pos - 1] = new LeafNode(vals);
            return pos;
        }
        int ll = n / 2;
        int rl = n - ll;
        int move = r - rl;
        Value[] newLeft = new Value[ll];
        Value[] newRight = new Value[rl];
        Array.copy(ls, l, newLeft);
        Array.copyFromStart(rs, move, newLeft, l);
        Array.copyToStart(rs, move, rl, newRight);
        nodes[pos - 1] = new LeafNode(newLeft);
        nodes[pos] = new LeafNode(newRight);
        return pos + 1;
    }

    @Override
    public NodeLike<Value, Value> slice(long off, long size) {
        int p = (int)off;
        int n = (int)size;
        Value[] out = new Value[n];
        Array.copyToStart(this.values, p, n, out);
        return n < 8 ? new PartialLeafNode(out) : new LeafNode(out);
    }

    @Override
    public int arity() {
        return this.values.length;
    }

    @Override
    public Value getSub(int index) {
        return this.values[index];
    }

    public String toString() {
        return Util.className(this) + "(" + this.size() + ")" + Arrays.toString(this.values);
    }
}

