/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQAtmIntMap;
import org.basex.query.value.map.XQAtmStrMap;
import org.basex.query.value.map.XQAtmValueMap;
import org.basex.query.value.map.XQHashMap;
import org.basex.query.value.map.XQIntMap;
import org.basex.query.value.map.XQIntStrMap;
import org.basex.query.value.map.XQIntValueMap;
import org.basex.query.value.map.XQItemValueMap;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.map.XQStrIntMap;
import org.basex.query.value.map.XQStrMap;
import org.basex.query.value.map.XQStrValueMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;

public final class MapBuilder {
    private final long capacity;
    private XQHashMap map;

    public MapBuilder() {
        this(2L);
    }

    public MapBuilder(long capacity) {
        this.capacity = capacity;
    }

    public MapBuilder put(Item key, Value value) throws QueryException {
        if (this.map == null) {
            Type k = key.type;
            SeqType v = value.seqType();
            int c = Array.initialCapacity(this.capacity);
            boolean ki = k == AtomType.INTEGER;
            boolean ks = k == AtomType.STRING;
            boolean ku = k == AtomType.UNTYPED_ATOMIC;
            boolean vi = v.eq(Types.INTEGER_O);
            boolean vs = v.eq(Types.STRING_O);
            this.map = ki ? (vi ? new XQIntMap(c) : (vs ? new XQIntStrMap(c) : new XQIntValueMap(c))) : (ks ? (vs ? new XQStrMap(c) : (vi ? new XQStrIntMap(c) : new XQStrValueMap(c))) : (ku ? (vs ? new XQAtmStrMap(c) : (vi ? new XQAtmIntMap(c) : new XQAtmValueMap(c))) : new XQItemValueMap(c)));
        }
        this.map = this.map.build(key, value);
        return this;
    }

    public MapBuilder put(Item key, byte[] value) throws QueryException {
        return this.put(key, (Value)Str.get(value));
    }

    public MapBuilder put(byte[] key, Value value) throws QueryException {
        return this.put((Item)Str.get(key), value);
    }

    public MapBuilder put(String key, Value value) throws QueryException {
        return this.put(Token.token(key), value);
    }

    public MapBuilder put(byte[] key, byte[] value) throws QueryException {
        return this.put(key, (Value)(value != null ? Str.get(value) : Empty.VALUE));
    }

    public MapBuilder put(String key, byte[] value) throws QueryException {
        return this.put(Token.token(key), value);
    }

    public MapBuilder put(String key, String value) throws QueryException {
        return this.put(Token.token(key), value != null ? Token.token(value) : null);
    }

    public Value get(Item key) throws QueryException {
        return this.map != null ? this.map.getOrNull(key) : null;
    }

    public boolean contains(Item key) throws QueryException {
        return this.map != null && this.map.contains(key);
    }

    public long size() {
        return this.map != null ? this.map.structSize() : 0L;
    }

    public XQMap map() {
        return this.map == null ? XQMap.empty() : (this.map.structSize() == 1L ? XQMap.get(this.map.keyAt(0), this.map.valueAt(0)) : this.map);
    }

    public XQMap map(Expr expr) {
        XQMap mp = this.map();
        mp.refineType(expr);
        return mp;
    }

    public String toString() {
        return Util.className(this) + "[" + String.valueOf(this.map) + "]";
    }
}

