/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.list.ElementList;

public abstract class ObjectList<E, L extends ObjectList<E, ?>>
extends ElementList
implements Iterable<E> {
    public E[] list;

    protected ObjectList(E ... list) {
        this.list = list;
    }

    protected abstract E[] newArray(int var1);

    public E get(int i) {
        return i < this.size ? (E)this.list[i] : null;
    }

    public boolean contains(E element) {
        E[] lst = this.list;
        int s = this.size;
        for (int l = 0; l < s; ++l) {
            if (!this.equals(lst[l], element)) continue;
            return true;
        }
        return false;
    }

    public L addUnique(E element) {
        if (!this.contains(element)) {
            this.add((L)element);
        }
        return (L)this;
    }

    public L add(E element) {
        int s = this.size;
        E[] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Array.copy(lst, this.newArray(this.newCapacity()));
        }
        lst[s] = element;
        this.size = s + 1;
        return (L)this;
    }

    public L add(E ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        E[] lst = this.list;
        if (ns > lst.length) {
            this.list = lst = Array.copy(lst, this.newArray(this.newCapacity(ns)));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.size = ns;
        return (L)this;
    }

    public L add(L elements) {
        for (E e : elements) {
            this.add((L)e);
        }
        return (L)this;
    }

    public final L set(int index, E element) {
        E[] lst = this.list;
        int s = this.size;
        int ns = index + 1;
        if (ns > lst.length) {
            this.list = lst = Array.copy(lst, this.newArray(this.newCapacity(ns)));
        }
        lst[index] = element;
        this.size = Math.max(s, ns);
        return (L)this;
    }

    public final L insert(int index, E ... elements) {
        int l = elements.length;
        if (l != 0) {
            int s = this.size;
            int ns = s + l;
            E[] lst = this.list;
            if (ns > lst.length) {
                this.list = lst = Array.copy(lst, this.newArray(this.newCapacity(ns)));
            }
            Array.insert(lst, index, l, s, elements);
            this.size = ns;
        }
        return (L)this;
    }

    public final E remove(int index) {
        E[] lst = this.list;
        E e = lst[index];
        Array.remove(lst, index, 1, this.size);
        lst[--this.size] = null;
        return e;
    }

    public boolean removeAll(E element) {
        int i;
        E[] lst = this.list;
        int s = this.size;
        int ns = 0;
        for (i = 0; i < s; ++i) {
            if (this.equals(lst[i], element)) continue;
            lst[ns++] = lst[i];
        }
        for (i = ns; i < s; ++i) {
            lst[i] = null;
        }
        this.size = ns;
        return s != ns;
    }

    public L removeAll(L elements) {
        for (E e : elements) {
            this.removeAll((L)e);
        }
        return (L)this;
    }

    public final E pop() {
        E[] lst = this.list;
        int sz = --this.size;
        E e = lst[sz];
        lst[sz] = null;
        return e;
    }

    public final void push(E element) {
        this.add((L)element);
    }

    public E peek() {
        return this.list[this.size - 1];
    }

    public L reverse() {
        E[] lst = this.list;
        int l = 0;
        for (int r = this.size - 1; l < r; ++l, --r) {
            E tmp = lst[l];
            lst[l] = lst[r];
            lst[r] = tmp;
        }
        return (L)this;
    }

    public final E[] toArray() {
        return Array.copy(this.list, this.newArray(this.size));
    }

    public E[] finish() {
        E[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Array.copy(lst, this.newArray(s));
    }

    public E[] next() {
        E[] lst = this.toArray();
        this.reset();
        return lst;
    }

    public final L sort(Comparator<E> comp, boolean ascending) {
        Arrays.sort(this.list, 0, this.size, ascending ? comp : Collections.reverseOrder(comp));
        return (L)this;
    }

    public boolean equals(E element1, E element2) {
        return Objects.equals(element1, element2);
    }

    public final L unique() {
        E[] lst = this.list;
        int s = this.size;
        if (s != 0) {
            int ns = 0;
            for (int l = 1; l < s; ++l) {
                if (this.equals(lst[l], lst[ns])) continue;
                lst[++ns] = lst[l];
            }
            this.size = ns + 1;
        }
        return (L)this;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this.list, this.size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ObjectList)) return false;
        ObjectList l = (ObjectList)obj;
        if (!Arrays.equals(this.list, 0, this.size, l.list, 0, l.size)) return false;
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

