/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.tools.bt;

import io.github.applecommander.applesingle.AppleSingle;
import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Optimization;
import io.github.applecommander.bastools.api.Parser;
import io.github.applecommander.bastools.api.TokenReader;
import io.github.applecommander.bastools.api.Visitors;
import io.github.applecommander.bastools.api.model.Program;
import io.github.applecommander.bastools.api.model.Token;
import io.github.applecommander.bastools.api.visitors.ByteVisitor;
import io.github.applecommander.bastools.tools.bt.HexDumper;
import io.github.applecommander.bastools.tools.bt.IntegerTypeConverter;
import io.github.applecommander.bastools.tools.bt.OptimizationTypeConverter;
import io.github.applecommander.bastools.tools.bt.VersionProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(description={"Transforms an AppleSoft program from text back to its tokenized state."}, descriptionHeading="%n", commandListHeading="%nCommands:%n", optionListHeading="%nOptions:%n", name="bt", mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
public class Main
implements Callable<Void> {
    private static final int BAS = 252;
    @CommandLine.Option(names={"-o", "--output"}, description={"Write binary output to file."})
    private File outputFile;
    @CommandLine.Option(names={"-x", "--hex"}, description={"Generate a binary hex dump for debugging."})
    private boolean hexFormat;
    @CommandLine.Option(names={"-c", "--copy"}, description={"Generate a copy/paste form of output for testing in an emulator."})
    private boolean copyFormat;
    @CommandLine.Option(names={"-a", "--address"}, description={"Base address for program"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, converter={IntegerTypeConverter.class})
    private int address = 2049;
    @CommandLine.Option(names={"--variables"}, description={"Generate a variable report"})
    private boolean showVariableReport;
    @CommandLine.Option(names={"--stdout"}, description={"Send binary output to stdout."})
    private boolean stdoutFlag;
    @CommandLine.Option(names={"--applesingle"}, description={"Write output in AppleSingle format"})
    private boolean applesingleFlag;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print structure as bastools understands it."})
    private boolean prettyPrint;
    @CommandLine.Option(names={"--list"}, description={"List structure as bastools understands it."})
    private boolean listPrint;
    @CommandLine.Option(names={"--tokens"}, description={"Dump token list to stdout for debugging."})
    private boolean showTokens;
    @CommandLine.Option(names={"--addresses"}, description={"Dump line number addresses out."})
    private boolean showLineAddresses;
    @CommandLine.Option(names={"--max-line-length"}, description={"Maximum line length for generated lines."}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int maxLineLength = 255;
    @CommandLine.Option(names={"--wrapper"}, description={"Wrap the Applesoft program (DOS 3.3)."})
    private boolean wrapProgram;
    @CommandLine.Option(names={"-f"}, converter={OptimizationTypeConverter.class}, split=",", description={"Enable specific optimizations.", "* @|green remove-empty-statements|@ - Strip out all '::'-like statements.", "* @|green remove-rem-statements|@ - Remove all REM statements.", "* @|green shorten-variable-names|@ - Ensure all variables are 1 or 2 characters long.", "* @|green extract-constant-values|@ - Assign all constant values first.", "* @|green merge-lines|@ - Merge lines.", "* @|green renumber|@ - Renumber program."})
    private List<Optimization> optimizations = new ArrayList();
    @CommandLine.Option(names={"-O", "--optimize"}, description={"Apply all optimizations."})
    private boolean allOptimizations;
    @CommandLine.Option(names={"--debug"}, description={"Print debug output."})
    private static boolean debugFlag;
    private PrintStream debug = new PrintStream((OutputStream)new /* Unavailable Anonymous Inner Class!! */);
    @CommandLine.Parameters(index="0", description={"AppleSoft BASIC program to process."})
    private File sourceFile;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        try {
            int exitCode = new CommandLine((Object)new Main()).execute(args);
            System.exit(exitCode);
        }
        catch (Throwable t) {
            if (debugFlag) {
                t.printStackTrace(System.err);
            } else {
                String message = t.getMessage();
                while (t != null) {
                    message = t.getMessage();
                    t = t.getCause();
                }
                System.err.printf("Error: %s\n", Optional.ofNullable(message).orElse("An error occurred."));
            }
            System.exit(1);
        }
    }

    @Override
    public Void call() throws FileNotFoundException, IOException {
        if (this.checkParameters()) {
            Configuration.Builder builder = Configuration.builder().maxLineLength(this.maxLineLength).sourceFile(this.sourceFile).startAddress(this.address);
            if (debugFlag) {
                builder.debugStream(System.out);
            }
            this.process(builder.build());
        }
        return null;
    }

    public boolean checkParameters() {
        boolean hasTextOutput;
        if (this.allOptimizations) {
            this.optimizations.clear();
            this.optimizations.addAll(Arrays.asList(Optimization.values()));
        }
        boolean bl = hasTextOutput = this.hexFormat || this.copyFormat || this.prettyPrint || this.listPrint || this.showTokens || this.showVariableReport || debugFlag || this.showLineAddresses;
        if (this.stdoutFlag && hasTextOutput) {
            System.err.println("The pipe option blocks any other stdout options.");
            return false;
        }
        if (!this.stdoutFlag && !hasTextOutput && this.outputFile == null) {
            System.err.println("What do you want to do?");
            return false;
        }
        return true;
    }

    public void process(Configuration config) throws FileNotFoundException, IOException {
        Queue tokens = TokenReader.tokenize((File)this.sourceFile);
        if (this.showTokens) {
            tokens.forEach(t -> System.out.printf("%s%s", t, t.type == Token.Type.EOL ? "\n" : ", "));
        }
        Parser parser = new Parser(tokens);
        Program program = parser.parse();
        for (Optimization optimization : this.optimizations) {
            this.debug.printf("Optimization: %s\n", optimization.name());
            program = program.accept(optimization.create(config));
        }
        if (this.prettyPrint || this.listPrint) {
            program.accept(Visitors.printBuilder().prettyPrint(this.prettyPrint).build());
        }
        if (this.showVariableReport) {
            program.accept(Visitors.variableReportVisitor());
        }
        ByteVisitor byteVisitor = Visitors.byteVisitor((Configuration)config);
        byte[] wrapperData = new byte[]{};
        if (this.wrapProgram) {
            Queue wrapperTokens = TokenReader.tokenize((InputStream)new ByteArrayInputStream("10 POKE 103,24:POKE 104,8:RUN".getBytes()));
            Parser wrapperParser = new Parser(wrapperTokens);
            Program wrapperProgram = wrapperParser.parse();
            wrapperData = byteVisitor.dump(wrapperProgram);
        }
        byte[] programData = byteVisitor.dump(program);
        if (this.showLineAddresses) {
            byteVisitor.getLineAddresses().forEach((l, a) -> System.out.printf("%5d ... $%04x\n", l, a));
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(wrapperData);
        output.write(programData);
        output.flush();
        byte[] data = output.toByteArray();
        if (this.hexFormat) {
            HexDumper.standard().dump(this.address, data);
        }
        if (this.copyFormat) {
            HexDumper.apple2().dump(this.address, data);
        }
        this.saveResults(data);
    }

    public void saveResults(byte[] data) throws IOException {
        if (this.applesingleFlag) {
            String realName = null;
            realName = this.sourceFile != null ? this.sourceFile.getName().toUpperCase() : (this.outputFile != null ? this.outputFile.getName().toUpperCase() : "UNKNOWN");
            if (realName.endsWith(".BAS")) {
                realName = realName.substring(0, realName.length() - 4);
            }
            AppleSingle as = AppleSingle.builder().auxType(this.address).fileType(252).dataFork(data).realName(realName).build();
            if (this.outputFile != null) {
                as.save(this.outputFile);
            }
            if (this.stdoutFlag) {
                as.save((OutputStream)System.out);
            }
        } else {
            if (this.outputFile != null) {
                Files.write(this.outputFile.toPath(), data, new OpenOption[0]);
            }
            if (this.stdoutFlag) {
                System.out.write(data);
            }
        }
    }
}

