/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.ResolvedServerInfo;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.Status;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public abstract class LoadBalancer {
    @Deprecated
    public void handleResolvedAddresses(List<ResolvedServerInfoGroup> servers, Attributes attributes) {
        throw new UnsupportedOperationException("This is deprecated and should not be called");
    }

    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
        ArrayList<ResolvedServerInfoGroup> serverInfoGroups = new ArrayList<ResolvedServerInfoGroup>(servers.size());
        for (EquivalentAddressGroup eag : servers) {
            ResolvedServerInfoGroup.Builder serverInfoGroupBuilder = ResolvedServerInfoGroup.builder(eag.getAttributes());
            for (SocketAddress addr : eag.getAddresses()) {
                serverInfoGroupBuilder.add(new ResolvedServerInfo(addr));
            }
            serverInfoGroups.add(serverInfoGroupBuilder.build());
        }
        this.handleResolvedAddresses(serverInfoGroups, attributes);
    }

    public abstract void handleNameResolutionError(Status var1);

    public abstract void handleSubchannelState(Subchannel var1, ConnectivityStateInfo var2);

    public abstract void shutdown();

    @ThreadSafe
    public static abstract class Factory {
        public abstract LoadBalancer newLoadBalancer(Helper var1);
    }

    @ThreadSafe
    public static abstract class Subchannel {
        public abstract void shutdown();

        public abstract void requestConnection();

        public abstract EquivalentAddressGroup getAddresses();

        public abstract Attributes getAttributes();
    }

    @ThreadSafe
    public static abstract class Helper {
        public abstract Subchannel createSubchannel(EquivalentAddressGroup var1, Attributes var2);

        public void updateSubchannelAddresses(Subchannel subchannel, EquivalentAddressGroup addrs) {
            throw new UnsupportedOperationException();
        }

        public abstract ManagedChannel createOobChannel(EquivalentAddressGroup var1, String var2);

        public void updateOobChannelAddresses(ManagedChannel channel, EquivalentAddressGroup eag) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public abstract void updatePicker(SubchannelPicker var1);

        public void updateBalancingState(@Nonnull ConnectivityState newState, @Nonnull SubchannelPicker newPicker) {
            this.updatePicker(newPicker);
        }

        public abstract void runSerialized(Runnable var1);

        public abstract NameResolver.Factory getNameResolverFactory();

        public abstract String getAuthority();
    }

    @Immutable
    public static final class PickResult {
        private static final PickResult NO_RESULT = new PickResult(null, null, Status.OK);
        @Nullable
        private final Subchannel subchannel;
        @Nullable
        private final ClientStreamTracer.Factory streamTracerFactory;
        private final Status status;

        private PickResult(@Nullable Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory, Status status) {
            this.subchannel = subchannel;
            this.streamTracerFactory = streamTracerFactory;
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
        }

        public static PickResult withSubchannel(Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory) {
            return new PickResult((Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel"), streamTracerFactory, Status.OK);
        }

        public static PickResult withSubchannel(Subchannel subchannel) {
            return PickResult.withSubchannel(subchannel, null);
        }

        public static PickResult withError(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"error status shouldn't be OK");
            return new PickResult(null, null, error);
        }

        public static PickResult withNoResult() {
            return NO_RESULT;
        }

        @Nullable
        public Subchannel getSubchannel() {
            return this.subchannel;
        }

        @Nullable
        public ClientStreamTracer.Factory getStreamTracerFactory() {
            return this.streamTracerFactory;
        }

        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("subchannel", (Object)this.subchannel).add("streamTracerFactory", (Object)this.streamTracerFactory).add("status", (Object)this.status).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.subchannel, this.status, this.streamTracerFactory});
        }

        public boolean equals(Object other) {
            if (!(other instanceof PickResult)) {
                return false;
            }
            PickResult that = (PickResult)other;
            return Objects.equal((Object)this.subchannel, (Object)that.subchannel) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.streamTracerFactory, (Object)that.streamTracerFactory);
        }
    }

    public static abstract class PickSubchannelArgs {
        public abstract CallOptions getCallOptions();

        public abstract Metadata getHeaders();

        public abstract MethodDescriptor<?, ?> getMethodDescriptor();
    }

    @ThreadSafe
    public static abstract class SubchannelPicker {
        public abstract PickResult pickSubchannel(PickSubchannelArgs var1);
    }
}

