/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class CacheIterateRequest
extends PartitionClientRequest
implements RetryableRequest {
    private String name;
    private int partitionId;
    private int tableIndex;
    private int batch;
    private InMemoryFormat inMemoryFormat;

    public CacheIterateRequest() {
    }

    public CacheIterateRequest(String name, int partitionId, int tableIndex, int batch, InMemoryFormat inMemoryFormat) {
        this.name = name;
        this.partitionId = partitionId;
        this.tableIndex = tableIndex;
        this.batch = batch;
        this.inMemoryFormat = inMemoryFormat;
    }

    @Override
    protected Operation prepareOperation() {
        ICacheService service = (ICacheService)this.getService();
        CacheOperationProvider cacheOperationProvider = service.getCacheOperationProvider(this.name, this.inMemoryFormat);
        return cacheOperationProvider.createKeyIteratorOperation(this.tableIndex, this.batch);
    }

    @Override
    protected int getPartition() {
        return this.partitionId;
    }

    @Override
    public final int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "read");
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeInt("p", this.partitionId);
        writer.writeInt("t", this.tableIndex);
        writer.writeInt("b", this.batch);
        writer.writeUTF("i", this.inMemoryFormat.name());
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
        this.partitionId = reader.readInt("p");
        this.tableIndex = reader.readInt("t");
        this.batch = reader.readInt("b");
        this.inMemoryFormat = InMemoryFormat.valueOf(reader.readUTF("i"));
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "iterator";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

