/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.PlaceholderMethod;
import com.google.errorprone.refaster.RefasterRule;
import com.google.errorprone.refaster.TemplateMatch;
import com.google.errorprone.refaster.UFreeIdent;
import com.google.errorprone.refaster.URepeated;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.UTypeVar;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.refaster.annotation.NoAutoboxing;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Warner;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class Template<M extends TemplateMatch>
implements Serializable {
    private static final Logger logger = Logger.getLogger(Template.class.toString());
    public static final boolean AUTOBOXING_DEFAULT = true;

    public abstract ImmutableClassToInstanceMap<Annotation> annotations();

    public abstract ImmutableList<UTypeVar> templateTypeVariables();

    public abstract ImmutableMap<String, UType> expressionArgumentTypes();

    public abstract Iterable<M> match(JCTree var1, Context var2);

    public abstract Fix replace(M var1);

    Iterable<UTypeVar> typeVariables(Context context) {
        ImmutableList<UTypeVar> ruleTypeVars = context.get(RefasterRule.RULE_TYPE_VARS);
        return Iterables.concat(ruleTypeVars == null ? ImmutableList.of() : ruleTypeVars, this.templateTypeVariables());
    }

    boolean autoboxing() {
        return !this.annotations().containsKey(NoAutoboxing.class);
    }

    protected List<Type> expectedTypes(Inliner inliner) throws CouldNotResolveImportException {
        ArrayList result = new ArrayList();
        ImmutableList types = this.expressionArgumentTypes().values().asList();
        ImmutableList argNames = this.expressionArgumentTypes().keySet().asList();
        for (int i = 0; i < argNames.size(); ++i) {
            Optional<java.util.List<JCTree.JCExpression>> exprs;
            String argName = (String)argNames.get(i);
            Optional<JCTree.JCExpression> singleBinding = inliner.getOptionalBinding(new UFreeIdent.Key((CharSequence)argName));
            if (!singleBinding.isPresent() && (!(exprs = inliner.getOptionalBinding(new URepeated.Key(argName))).isPresent() || ((java.util.List)exprs.get()).isEmpty())) continue;
            result.add(((UType)types.get(i)).inline(inliner));
        }
        for (PlaceholderMethod.PlaceholderExpressionKey key : Ordering.natural().immutableSortedCopy(Iterables.filter((Iterable)inliner.bindings.keySet(), PlaceholderMethod.PlaceholderExpressionKey.class))) {
            result.add(key.method.returnType().inline(inliner));
        }
        return List.from(result);
    }

    protected List<Type> actualTypes(Inliner inliner) {
        ArrayList<Type> result = new ArrayList<Type>();
        ImmutableList argNames = this.expressionArgumentTypes().keySet().asList();
        for (int i = 0; i < this.expressionArgumentTypes().size(); ++i) {
            String argName = (String)argNames.get(i);
            Optional<JCTree.JCExpression> singleBinding = inliner.getOptionalBinding(new UFreeIdent.Key((CharSequence)argName));
            if (singleBinding.isPresent()) {
                result.add(((JCTree.JCExpression)singleBinding.get()).type);
                continue;
            }
            Optional<java.util.List<JCTree.JCExpression>> exprs = inliner.getOptionalBinding(new URepeated.Key(argName));
            if (!exprs.isPresent() || ((java.util.List)exprs.get()).isEmpty()) continue;
            Type[] exprTys = new Type[((java.util.List)exprs.get()).size()];
            for (int j = 0; j < ((java.util.List)exprs.get()).size(); ++j) {
                exprTys[j] = ((JCTree.JCExpression)((java.util.List)exprs.get()).get((int)j)).type;
            }
            result.add(inliner.types().lub(List.from(exprTys)));
        }
        for (PlaceholderMethod.PlaceholderExpressionKey key : Ordering.natural().immutableSortedCopy(Iterables.filter((Iterable)inliner.bindings.keySet(), PlaceholderMethod.PlaceholderExpressionKey.class))) {
            result.add(inliner.getBinding(key).type);
        }
        return List.from(result);
    }

    @Nullable
    protected Optional<Unifier> typecheck(Unifier unifier, Inliner inliner, Warner warner, List<Type> expectedTypes, List<Type> actualTypes) {
        try {
            ImmutableList<UTypeVar> freeTypeVars = this.freeTypeVars(unifier);
            this.infer(warner, inliner, inliner.inlineList(freeTypeVars), expectedTypes, inliner.symtab().voidType, actualTypes);
            for (UTypeVar var : freeTypeVars) {
                Type instantiationForVar = this.infer(warner, inliner, inliner.inlineList(freeTypeVars), expectedTypes, var.inline(inliner), actualTypes);
                unifier.putBinding(var.key(), UTypeVar.TypeWithExpression.create(instantiationForVar.getReturnType()));
            }
            if (!this.checkBounds(unifier, inliner, warner)) {
                return Optional.absent();
            }
            return Optional.of((Object)unifier);
        }
        catch (CouldNotResolveImportException e) {
            logger.log(Level.FINE, "Failure to resolve an import", e);
            return Optional.absent();
        }
        catch (InferException e) {
            logger.log(Level.FINE, "No valid instantiation found: " + e.getMessage());
            return Optional.absent();
        }
    }

    private boolean checkBounds(Unifier unifier, Inliner inliner, Warner warner) throws CouldNotResolveImportException {
        Types types = unifier.types();
        ListBuffer<Type.TypeVar> varsBuffer = new ListBuffer<Type.TypeVar>();
        ListBuffer<Type> bindingsBuffer = new ListBuffer<Type>();
        for (UTypeVar typeVar : this.typeVariables(unifier.getContext())) {
            varsBuffer.add(inliner.inlineAsVar(typeVar));
            bindingsBuffer.add(unifier.getBinding(typeVar.key()).type());
        }
        List<Type> vars = varsBuffer.toList();
        List<Type> bindings = bindingsBuffer.toList();
        for (UTypeVar typeVar : this.typeVariables(unifier.getContext())) {
            List<Type> bounds = types.getBounds(inliner.inlineAsVar(typeVar));
            bounds = types.subst(bounds, vars, bindings);
            if (types.isSubtypeUnchecked(unifier.getBinding(typeVar.key()).type(), bounds, warner)) continue;
            logger.log(Level.FINE, String.format("%s is not a subtype of %s", inliner.getBinding(typeVar.key()), bounds));
            return false;
        }
        return true;
    }

    protected static Pretty pretty(Context context, final Writer writer) {
        final JCTree.JCCompilationUnit unit = context.get(JCTree.JCCompilationUnit.class);
        try {
            final String unitContents = unit.getSourceFile().getCharContent(false).toString();
            return new Pretty(writer, true){
                {
                    super(x0, x1);
                    this.width = 0;
                }

                @Override
                public void visitAnnotation(JCTree.JCAnnotation anno) {
                    if (((List)anno.getArguments()).isEmpty()) {
                        try {
                            this.print("@");
                            this.printExpr(anno.annotationType);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        super.visitAnnotation(anno);
                    }
                }

                @Override
                public void printExpr(JCTree tree, int prec) throws IOException {
                    boolean hasRealEndPosition;
                    EndPosTable endPositions = unit.endPositions;
                    int endPos = endPositions.getEndPos(tree);
                    boolean bl = hasRealEndPosition = endPos != -1;
                    if (tree.getKind() != Tree.Kind.MODIFIERS && hasRealEndPosition) {
                        writer.append(unitContents.substring(tree.getStartPosition(), endPos));
                    } else {
                        super.printExpr(tree, prec);
                    }
                }

                @Override
                public void visitApply(JCTree.JCMethodInvocation tree) {
                    JCTree.JCExpression select = tree.getMethodSelect();
                    if (select != null && select.toString().equals("Refaster.emitCommentBefore")) {
                        String commentLiteral = (String)((JCTree.JCLiteral)((List)tree.getArguments()).get(0)).getValue();
                        JCTree.JCExpression expr = (JCTree.JCExpression)((List)tree.getArguments()).get(1);
                        try {
                            this.print("/* " + commentLiteral + " */ ");
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        expr.accept(this);
                    } else {
                        super.visitApply(tree);
                    }
                }

                @Override
                public void printStat(JCTree tree) throws IOException {
                    JCTree.JCMethodInvocation invocation;
                    JCTree.JCExpression select;
                    if (tree instanceof JCTree.JCExpressionStatement && ((JCTree.JCExpressionStatement)tree).getExpression() instanceof JCTree.JCMethodInvocation && (select = (invocation = (JCTree.JCMethodInvocation)((JCTree.JCExpressionStatement)tree).getExpression()).getMethodSelect()) != null && select.toString().equals("Refaster.emitComment")) {
                        String commentLiteral = (String)((JCTree.JCLiteral)((List)invocation.getArguments()).get(0)).getValue();
                        this.print("// " + commentLiteral);
                        return;
                    }
                    super.printStat(tree);
                }

                @Override
                public void visitLambda(JCTree.JCLambda lambda) {
                    try {
                        boolean exactlyOneParamWithNoType;
                        boolean bl = exactlyOneParamWithNoType = lambda.params.size() == 1 && lambda.params.get((int)0).vartype == null;
                        if (!exactlyOneParamWithNoType) {
                            this.print("(");
                        }
                        boolean first = true;
                        for (JCTree.JCVariableDecl param : lambda.params) {
                            if (!first) {
                                this.print(",");
                            }
                            if (param.vartype != null) {
                                if (!first) {
                                    this.print(" ");
                                }
                                this.print(param.vartype + " ");
                            }
                            this.print(param.name);
                            first = false;
                        }
                        if (!exactlyOneParamWithNoType) {
                            this.print(")");
                        }
                        this.print("->");
                        this.printExpr(lambda.body);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public void visitTry(JCTree.JCTry tree) {
                    if (((List)tree.getResources()).isEmpty()) {
                        super.visitTry(tree);
                        return;
                    }
                    try {
                        this.print("try (");
                        boolean first = true;
                        for (JCTree resource : tree.getResources()) {
                            if (!first) {
                                this.print(";");
                                this.println();
                            }
                            this.printExpr(resource);
                            first = false;
                        }
                        this.print(")");
                        this.printStat(tree.body);
                        for (JCTree.JCCatch catchStmt : tree.getCatches()) {
                            this.printStat(catchStmt);
                        }
                        if (tree.getFinallyBlock() != null) {
                            this.print(" finally ");
                            this.printStat(tree.getFinallyBlock());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type infer(Warner warner, Inliner inliner, List<Type> freeTypeVariables, List<Type> expectedArgTypes, Type returnType, List<Type> actualArgTypes) throws InferException {
        Object resultInfo;
        Symtab symtab = inliner.symtab();
        Type methodType = new Type.MethodType(expectedArgTypes, returnType, List.nil(), symtab.methodClass);
        if (!freeTypeVariables.isEmpty()) {
            methodType = new Type.ForAll(freeTypeVariables, methodType);
        }
        Enter enter = inliner.enter();
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(0L, inliner.asName("__m__"), methodType, symtab.unknownSymbol);
        Type site = symtab.methodClass.type;
        Env<AttrContext> env = enter.getTopLevelEnv(TreeMaker.instance(inliner.getContext()).TopLevel(List.nil()));
        try {
            Field field = AttrContext.class.getDeclaredField("pendingResolutionPhase");
            field.setAccessible(true);
            field.set(env.info, Template.newMethodResolutionPhase(this.autoboxing()));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
        try {
            Class<?> resultInfoClass = Class.forName("com.sun.tools.javac.comp.Attr$ResultInfo");
            Constructor<?> resultInfoCtor = resultInfoClass.getDeclaredConstructor(Attr.class, Kinds.KindSelector.class, Type.class);
            resultInfoCtor.setAccessible(true);
            resultInfo = resultInfoCtor.newInstance(Attr.instance(inliner.getContext()), Kinds.KindSelector.PCK, Type.noType);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
        Log.DeferredDiagnosticHandler handler = new Log.DeferredDiagnosticHandler(Log.instance(inliner.getContext()));
        try {
            Type.MethodType result = this.callCheckMethod(warner, inliner, resultInfo, actualArgTypes, methodSymbol, site, env);
            if (!handler.getDiagnostics().isEmpty()) {
                throw new InferException(handler.getDiagnostics());
            }
            Type.MethodType methodType2 = result;
            return methodType2;
        }
        finally {
            Log.instance(inliner.getContext()).popDiagnosticHandler(handler);
        }
    }

    private static Object newMethodResolutionPhase(boolean autoboxing) {
        for (Class<?> c : Resolve.class.getDeclaredClasses()) {
            if (!c.getName().equals("com.sun.tools.javac.comp.Resolve$MethodResolutionPhase")) continue;
            for (Object e : c.getEnumConstants()) {
                if (!e.toString().equals(autoboxing ? "BOX" : "BASIC")) continue;
                return e;
            }
        }
        return null;
    }

    private Type.MethodType callCheckMethod(Warner warner, Inliner inliner, Object resultInfo, List<Type> actualArgTypes, Symbol.MethodSymbol methodSymbol, Type site, Env<AttrContext> env) throws InferException {
        try {
            Method checkMethod = Resolve.class.getDeclaredMethod("checkMethod", Env.class, Type.class, Symbol.class, Class.forName("com.sun.tools.javac.comp.Attr$ResultInfo"), List.class, List.class, Warner.class);
            checkMethod.setAccessible(true);
            return (Type.MethodType)checkMethod.invoke((Object)Resolve.instance(inliner.getContext()), env, site, methodSymbol, resultInfo, actualArgTypes, List.nil(), warner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Resolve.InapplicableMethodException) {
                throw new InferException((Collection<JCDiagnostic>)ImmutableList.of((Object)((Resolve.InapplicableMethodException)e.getTargetException()).getDiagnostic()));
            }
            throw new LinkageError(e.getMessage(), e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private ImmutableList<UTypeVar> freeTypeVars(Unifier unifier) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (UTypeVar var : this.typeVariables(unifier.getContext())) {
            if (unifier.getBinding(var.key()) != null) continue;
            builder.add((Object)var);
        }
        return builder.build();
    }

    protected static Fix addImports(Inliner inliner, SuggestedFix.Builder fix) {
        for (String importToAdd : inliner.getImportsToAdd()) {
            fix.addImport(importToAdd);
        }
        for (String staticImportToAdd : inliner.getStaticImportsToAdd()) {
            fix.addStaticImport(staticImportToAdd);
        }
        return fix.build();
    }

    private static class InferException
    extends Exception {
        final Collection<JCDiagnostic> diagnostics;

        public InferException(Collection<JCDiagnostic> diagnostics) {
            this.diagnostics = diagnostics;
        }

        @Override
        public String getMessage() {
            return "Inference failed with the following error(s): " + this.diagnostics.toString();
        }
    }
}

