/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import com.google.auto.value.processor.JavaScanner;

class Reformatter {
    Reformatter() {
    }

    static String fixup(String s) {
        s = Reformatter.removeTrailingSpace(s);
        s = Reformatter.compressBlankLines(s);
        s = Reformatter.compressSpace(s);
        return s;
    }

    private static String removeTrailingSpace(String s) {
        if (!s.endsWith("\n")) {
            s = s + '\n';
        }
        StringBuilder sb = new StringBuilder(s.length());
        int start = 0;
        while (start < s.length()) {
            int i;
            int nl = s.indexOf(10, start);
            for (i = nl - 1; i >= start && s.charAt(i) == ' '; --i) {
            }
            sb.append(s.substring(start, i + 1)).append('\n');
            start = nl + 1;
        }
        return sb.toString();
    }

    private static String compressBlankLines(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int braces = 0;
        int parens = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '(': {
                    ++parens;
                    break;
                }
                case ')': {
                    --parens;
                    break;
                }
                case '{': {
                    ++braces;
                    break;
                }
                case '}': {
                    --braces;
                    break;
                }
                case '\n': {
                    int j;
                    for (j = i + 1; j < s.length() && s.charAt(j) == '\n'; ++j) {
                    }
                    if (j <= i + 1) break;
                    if (parens == 0 && braces <= 1) {
                        sb.append("\n");
                    }
                    i = j - 1;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String compressSpace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        JavaScanner tokenizer = new JavaScanner(s);
        int len = s.length();
        int start = 0;
        while (start < len) {
            int end = tokenizer.tokenEnd(start);
            if (s.charAt(start) == ' ') {
                char nextC;
                if (sb.charAt(sb.length() - 1) != '(' && ".,;)".indexOf(nextC = s.charAt(end)) < 0) {
                    sb.append(' ');
                }
            } else {
                sb.append(s.substring(start, end));
            }
            start = end;
        }
        return sb.toString();
    }
}

