/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.sym;

import com.google.errorprone.annotations.Immutable;
import com.google.turbine.binder.sym.Symbol;

@Immutable
public class ClassSymbol
implements Symbol {
    public static final ClassSymbol OBJECT = new ClassSymbol("java/lang/Object");
    public static final ClassSymbol STRING = new ClassSymbol("java/lang/String");
    public static final ClassSymbol ENUM = new ClassSymbol("java/lang/Enum");
    public static final ClassSymbol ANNOTATION = new ClassSymbol("java/lang/annotation/Annotation");
    private final String className;

    public ClassSymbol(String className) {
        this.className = className;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return this.className.replace('/', '.');
    }

    public boolean equals(Object o) {
        return o instanceof ClassSymbol && this.className.equals(((ClassSymbol)o).className);
    }

    public String binaryName() {
        return this.className;
    }

    @Override
    public Symbol.Kind symKind() {
        return Symbol.Kind.CLASS;
    }
}

